/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.pdftools;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.wrapper.CmsWrappedResource;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.pdftools.CmsPdfCache;
import org.opencms.pdftools.CmsPdfConverter;
import org.opencms.pdftools.CmsPdfFormatterUtils;
import org.opencms.pdftools.CmsPdfLink;
import org.opencms.pdftools.CmsPdfThumbnailCache;
import org.opencms.pdftools.CmsPdfThumbnailGenerator;
import org.opencms.pdftools.CmsPdfThumbnailLink;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsStringUtil;

public class CmsPdfResourceHandler
implements I_CmsResourceInit {
    public static final String IMAGE_MIMETYPECONFIG = "png:image/png|gif:image/gif|jpg:image/jpeg";
    public static final Map<String, String> IMAGE_MIMETYPES = Collections.unmodifiableMap(CmsStringUtil.splitAsMap("png:image/png|gif:image/gif|jpg:image/jpeg", "|", ":"));
    private static final Log LOG = CmsLog.getLog(CmsPdfResourceHandler.class);
    private CmsPdfCache m_pdfCache;
    private CmsPdfConverter m_pdfConverter = new CmsPdfConverter();
    private CmsPdfThumbnailCache m_thumbnailCache = new CmsPdfThumbnailCache();

    public CmsPdfResourceHandler() {
        this.m_pdfCache = new CmsPdfCache();
    }

    @Override
    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest request, HttpServletResponse response) throws CmsResourceInitException, CmsSecurityException {
        boolean abort;
        boolean bl = abort = resource != null || cms.getRequestContext().getUri().startsWith("/system/");
        if (abort) {
            return resource;
        }
        if (response != null) {
            String uri = cms.getRequestContext().getUri();
            try {
                if (uri.contains("pdflink")) {
                    this.handlePdfLink(cms, request, response, uri);
                    return null;
                }
                if (uri.contains("pdfthumbnail")) {
                    this.handleThumbnailLink(cms, request, response, uri);
                    return null;
                }
                return null;
            }
            catch (CmsResourceInitException e) {
                throw e;
            }
            catch (CmsSecurityException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            catch (CmsPdfLink.CmsPdfLinkParseException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
            catch (CmsPdfThumbnailLink.ParseException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                throw new CmsRuntimeException(Messages.get().container("ERR_RESOURCE_INIT_ABORTED_1", CmsPdfResourceHandler.class.getName()), (Throwable)e);
            }
        }
        return null;
    }

    protected void handlePdfLink(CmsObject cms, HttpServletRequest request, HttpServletResponse response, String uri) throws Exception {
        CmsPdfLink linkObj = new CmsPdfLink(cms, uri);
        CmsResource formatter = linkObj.getFormatter();
        CmsResource content = linkObj.getContent();
        LOG.info((Object)("Trying to render " + content.getRootPath() + " using " + formatter.getRootPath()));
        Locale locale = linkObj.getLocale();
        CmsObject cmsForJspExecution = OpenCms.initCmsObject(cms);
        cmsForJspExecution.getRequestContext().setLocale(locale);
        cmsForJspExecution.getRequestContext().setSiteRoot("");
        byte[] result = null;
        String cacheParams = formatter.getStructureId() + ";" + formatter.getDateLastModified() + ";" + locale;
        String cacheName = this.m_pdfCache.getCacheName(content, cacheParams);
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            result = this.m_pdfCache.getCacheContent(cacheName);
        }
        if (result == null) {
            cmsForJspExecution.getRequestContext().setUri(content.getRootPath());
            byte[] xhtmlData = CmsPdfFormatterUtils.executeJsp(cmsForJspExecution, request, response, formatter, content);
            LOG.info((Object)("Rendered XHTML from " + content.getRootPath() + " using " + formatter.getRootPath()));
            if (LOG.isDebugEnabled()) {
                this.logXhtmlOutput(formatter, content, xhtmlData);
            }
            result = this.m_pdfConverter.convertXhtmlToPdf(cmsForJspExecution, xhtmlData, "opencms://" + uri);
            LOG.info((Object)("Converted XHTML to PDF, size=" + result.length));
            this.m_pdfCache.saveCacheFile(cacheName, result);
        } else {
            LOG.info((Object)("Retrieved PDF data from cache for content " + content.getRootPath() + " and formatter " + formatter.getRootPath()));
        }
        response.setContentType("application/pdf");
        response.getOutputStream().write(result);
        CmsResourceInitException initEx = new CmsResourceInitException(CmsPdfResourceHandler.class);
        initEx.setClearErrors(true);
        throw initEx;
    }

    protected void logXhtmlOutput(CmsResource formatter, CmsResource content, byte[] xhtmlData) {
        try {
            String xhtmlString = new String(xhtmlData, "UTF-8");
            LOG.debug((Object)("(PDF generation) The formatter " + formatter.getRootPath() + " generated the following XHTML source from " + content.getRootPath() + ":"));
            LOG.debug((Object)xhtmlString);
        }
        catch (Exception e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void handleThumbnailLink(CmsObject cms, HttpServletRequest request, HttpServletResponse response, String uri) throws Exception {
        String options = request.getParameter("options");
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(options)) {
            options = "w:64";
        }
        CmsPdfThumbnailLink linkObj = new CmsPdfThumbnailLink(cms, uri, options);
        CmsResource pdf = linkObj.getPdfResource();
        CmsFile pdfFile = cms.readFile(pdf);
        CmsPdfThumbnailGenerator thumbnailGenerator = new CmsPdfThumbnailGenerator();
        CmsWrappedResource wrapperWithImageExtension = new CmsWrappedResource(pdfFile);
        wrapperWithImageExtension.setRootPath(pdfFile.getRootPath() + "." + linkObj.getFormat());
        String cacheName = this.m_thumbnailCache.getCacheName(wrapperWithImageExtension.getResource(), options + ";" + linkObj.getFormat());
        byte[] imageData = this.m_thumbnailCache.getCacheContent(cacheName);
        if (imageData == null) {
            imageData = thumbnailGenerator.generateThumbnail(new ByteArrayInputStream(pdfFile.getContents()), linkObj.getWidth(), linkObj.getHeight(), linkObj.getFormat(), linkObj.getPage());
            this.m_thumbnailCache.saveCacheFile(cacheName, imageData);
        }
        response.setContentType(IMAGE_MIMETYPES.get(linkObj.getFormat()));
        response.getOutputStream().write(imageData);
        CmsResourceInitException initEx = new CmsResourceInitException(CmsPdfResourceHandler.class);
        initEx.setClearErrors(true);
        throw initEx;
    }
}

