/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import java.util.concurrent.ConcurrentHashMap;
import org.opencms.db.CmsPublishList;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.publish.CmsPublishException;
import org.opencms.publish.Messages;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsPublishListVerifier {
    private ConcurrentHashMap<CmsUUID, ForbiddenFolderEntry> m_forbiddenParentFolders = new ConcurrentHashMap();

    public CmsUUID addForbiddenParentFolder(String parentFolder, String reason) {
        CmsUUID id = new CmsUUID();
        this.m_forbiddenParentFolders.put(id, new ForbiddenFolderEntry(parentFolder, reason));
        return id;
    }

    public void checkPublishList(CmsPublishList publishList) throws CmsException {
        for (CmsResource resource : publishList.getAllResources()) {
            for (ForbiddenFolderEntry entry : this.m_forbiddenParentFolders.values()) {
                if (!CmsStringUtil.isPrefixPath(entry.getRootPath(), resource.getRootPath())) continue;
                throw new CmsPublishException(Messages.get().container("ERR_PUBLISH_FORBIDDEN_PARENT_FOLDER_3", resource.getRootPath(), entry.getRootPath(), entry.getReason()));
            }
        }
    }

    public void removeForbiddenParentFolder(CmsUUID id) {
        this.m_forbiddenParentFolders.remove(id);
    }

    private class ForbiddenFolderEntry {
        String m_reason;
        String m_rootPath;

        public ForbiddenFolderEntry(String rootPath, String reason) {
            this.m_rootPath = rootPath;
            this.m_reason = reason;
        }

        public String getReason() {
            return this.m_reason;
        }

        public String getRootPath() {
            return this.m_rootPath;
        }
    }
}

