/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationValidatorInfoEntry;

public class CmsRelationDeleteValidator {
    private static final Log LOG = CmsLog.getLog(CmsRelationDeleteValidator.class);
    protected Map<String, List<CmsRelation>> m_brokenRelations;
    private CmsObject m_cms;

    public CmsRelationDeleteValidator(CmsObject cms, List<String> resourceNames, boolean includeSiblings) {
        this.m_cms = cms;
        this.m_brokenRelations = this.getBrokenRelations(resourceNames, includeSiblings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsRelationValidatorInfoEntry getInfoEntry(String resourceName) {
        String resName = resourceName;
        String siteRoot = this.m_cms.getRequestContext().getSiteRoot();
        String siteName = null;
        if (resName.startsWith(this.m_cms.getRequestContext().getSiteRoot())) {
            resName = this.m_cms.getRequestContext().removeSiteRoot(resName);
        } else {
            siteName = siteRoot = OpenCms.getSiteManager().getSiteRoot(resName);
            if (siteRoot != null) {
                String oldSite = this.m_cms.getRequestContext().getSiteRoot();
                try {
                    this.m_cms.getRequestContext().setSiteRoot("/");
                    siteName = this.m_cms.readPropertyObject(siteRoot, "Title", false).getValue(siteRoot);
                }
                catch (CmsException e) {
                    siteName = siteRoot;
                }
                finally {
                    this.m_cms.getRequestContext().setSiteRoot(oldSite);
                }
                resName = resName.substring(siteRoot.length());
            } else {
                siteName = "/";
            }
        }
        return new CmsRelationValidatorInfoEntry(resourceName, resName, siteName, siteRoot, Collections.unmodifiableList(this.m_brokenRelations.get(resourceName)));
    }

    public boolean isEmpty() {
        return this.m_brokenRelations.isEmpty();
    }

    public Set<String> keySet() {
        return this.m_brokenRelations.keySet();
    }

    public Collection<List<CmsRelation>> values() {
        return this.m_brokenRelations.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<CmsRelation>> getBrokenRelations(List<String> resourceNames, boolean includeSiblings) {
        String site;
        HashMap<String, List<CmsRelation>> brokenRelations = new HashMap<String, List<CmsRelation>>();
        HashSet<String> resources = new HashSet<String>();
        String oldSite = site = this.m_cms.getRequestContext().getSiteRoot();
        try {
            this.m_cms.getRequestContext().setSiteRoot("/");
            ArrayList<CmsResource> resourceList = new ArrayList<CmsResource>();
            Iterator<String> itResourceNames = resourceNames.iterator();
            while (itResourceNames.hasNext()) {
                String resName = this.m_cms.getRequestContext().addSiteRoot(site, itResourceNames.next());
                try {
                    CmsResource resource = this.m_cms.readResource(resName);
                    resourceList.add(resource);
                    if (!resource.isFolder()) continue;
                    resourceList.addAll(this.m_cms.readResources(resName, CmsResourceFilter.IGNORE_EXPIRATION, true));
                }
                catch (CmsException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            for (CmsResource resource : resourceList) {
                resources.add(resource.getRootPath());
            }
            if (Boolean.valueOf(includeSiblings).booleanValue()) {
                for (CmsResource resource : new ArrayList(resourceList)) {
                    try {
                        if (resource.isFolder() || resource.getSiblingCount() <= 1) continue;
                        for (CmsResource sibling : this.m_cms.readSiblings(resource.getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION)) {
                            if (resources.contains(sibling.getRootPath())) continue;
                            resources.add(sibling.getRootPath());
                            resourceList.add(sibling);
                        }
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            for (CmsResource resource : resourceList) {
                String resourceName = resource.getRootPath();
                try {
                    for (CmsRelation relation : this.m_cms.getRelationsForResource(resource, CmsRelationFilter.SOURCES)) {
                        String relationName = relation.getSourcePath();
                        if (resources.contains(relationName)) continue;
                        ArrayList<CmsRelation> broken = (ArrayList<CmsRelation>)brokenRelations.get(resourceName);
                        if (broken == null) {
                            broken = new ArrayList<CmsRelation>();
                            brokenRelations.put(resourceName, broken);
                        }
                        broken.add(relation);
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        finally {
            this.m_cms.getRequestContext().setSiteRoot(oldSite);
        }
        return brokenRelations;
    }
}

