/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.report.A_CmsReport;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;

public class CmsVaadinHtmlReport
extends A_CmsReport {
    public static final int FORMAT_NEWLINE = -1;
    private static final Log LOG = CmsLog.getLog(CmsVaadinHtmlReport.class);
    private List<Object> m_content;
    private int m_indexNext;
    private CmsLogReport m_logReport;
    private StringTemplateGroup m_templateGroup;
    private boolean m_transient;
    private boolean m_writeHtml;

    public CmsVaadinHtmlReport(Locale locale, String siteRoot, boolean writeHtml, boolean isTransient, Object logChannel) {
        this.init(locale, siteRoot);
        if (logChannel != null) {
            this.m_logReport = new CmsLogReport(locale, logChannel);
        }
        this.m_content = new ArrayList<Object>(256);
        this.m_writeHtml = writeHtml;
        this.m_transient = isTransient;
        try (InputStream stream = CmsVaadinHtmlReport.class.getResourceAsStream("report.st");){
            try {
                this.m_templateGroup = new StringTemplateGroup((Reader)new InputStreamReader(stream, "UTF-8"), DefaultTemplateLexer.class, new StringTemplateErrorListener(){

                    public void error(String arg0, Throwable arg1) {
                        LOG.error((Object)(arg0 + ": " + arg1.getMessage()), arg1);
                    }

                    public void warning(String arg0) {
                        LOG.warn((Object)arg0);
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CmsVaadinHtmlReport(Locale locale, String siteRoot, Object logChannel) {
        this(locale, siteRoot, false, false, logChannel);
    }

    @Override
    public synchronized String getReportUpdate() {
        StringBuffer result = new StringBuffer();
        int indexEnd = this.m_content.size();
        for (int i = this.m_indexNext; i < indexEnd; ++i) {
            boolean needsParam;
            int pos = this.m_transient ? 0 : i;
            Object obj = this.m_content.get(pos);
            ReportEntry entry = (ReportEntry)obj;
            StringTemplate template = this.m_templateGroup.getInstanceOf(entry.getType());
            boolean bl = needsParam = template.getFormalArguments().get("message") != null;
            if (needsParam) {
                template.setAttribute("message", entry.getMessage());
            }
            result.append(template.toString());
            if (!this.m_transient) continue;
            this.m_content.remove(this.m_indexNext);
        }
        this.m_indexNext = this.m_transient ? 0 : indexEnd;
        return result.toString();
    }

    public boolean isWriteHtml() {
        return this.m_writeHtml;
    }

    @Override
    public synchronized void print(String value, int format) {
        if (this.m_logReport != null) {
            this.m_logReport.print(value, format);
        }
        String[] names = I_CmsReport.FORMAT_NAMES;
        String formatName = null;
        if (format == -1) {
            formatName = "NEWLINE";
        } else if (format < names.length) {
            formatName = names[format];
        }
        if (formatName != null) {
            ReportEntry message = new ReportEntry(formatName, value);
            this.m_content.add(message);
            this.setLastEntryTime(System.currentTimeMillis());
        }
    }

    @Override
    public void println() {
        if (this.m_logReport != null) {
            this.m_logReport.println();
        }
        this.print("", -1);
    }

    @Override
    public synchronized void println(Throwable t) {
        if (this.m_logReport != null) {
            this.m_logReport.println(t);
        }
        this.addError(t.getMessage());
        this.m_content.add(new ReportEntry("EXCEPTION", t));
        this.setLastEntryTime(System.currentTimeMillis());
    }

    class ReportEntry {
        private Object m_message;
        private String m_type;

        public ReportEntry(String type, Object message) {
            this.m_type = type;
            this.m_message = message;
        }

        public Object getMessage() {
            return this.m_message;
        }

        public String getType() {
            return this.m_type;
        }
    }
}

