/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler.jobs;

import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.util.CmsStringUtil;

public class CmsSearchIndexOptimizeJob
implements I_CmsScheduledJob {
    public static final String PARAM_INDEXES_EXCLUDED = "excludeIndexes";
    public static final String PARAM_INDEXES_OPTIMIZED = "optimizeIndexes";

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        List<String> optimizeIndexes = null;
        List<String> excludeIndexes = null;
        String oi = parameters.get(PARAM_INDEXES_OPTIMIZED);
        if (oi != null) {
            optimizeIndexes = CmsStringUtil.splitAsList(oi, ',', true);
            if (optimizeIndexes.isEmpty()) {
                optimizeIndexes = null;
            }
        } else {
            oi = parameters.get(PARAM_INDEXES_EXCLUDED);
            if (oi != null && (excludeIndexes = CmsStringUtil.splitAsList(oi, ',', true)).isEmpty()) {
                excludeIndexes = null;
            }
        }
        for (CmsSearchIndex index : OpenCms.getSearchManager().getSearchIndexes()) {
            if (!index.isUpdatedIncremental() || !(optimizeIndexes == null && excludeIndexes == null || optimizeIndexes != null && optimizeIndexes.contains(index.getName())) && (excludeIndexes == null || excludeIndexes.contains(index.getName()))) continue;
            I_CmsIndexWriter writer = index.getIndexWriter(null, false);
            writer.optimize();
        }
        return null;
    }
}

