/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.Messages;
import org.opencms.search.galleries.CmsGallerySearchParameters;
import org.opencms.util.CmsStringUtil;

public final class CmsSearchUtil {
    private static final DateFormat DATEFORMAT_ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final Log LOG = CmsLog.getLog(CmsSearchUtil.class);
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    private CmsSearchUtil() {
    }

    public static List<String> computeScopeFolders(CmsObject cms, CmsGallerySearchParameters params) {
        String subsite = null;
        if (params.getReferencePath() != null) {
            subsite = OpenCms.getADEManager().getSubSiteRoot(cms, cms.getRequestContext().addSiteRoot(params.getReferencePath()));
            if (subsite != null) {
                subsite = cms.getRequestContext().removeSiteRoot(subsite);
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_GALLERIES_COULD_NOT_EVALUATE_SUBSITE_1", params.getReferencePath()));
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_GALLERIES_NO_REFERENCE_PATH_PROVIDED_0"));
        }
        List<String> scopeFolders = CmsSearchUtil.getSearchRootsForScope(params.getScope(), cms.getRequestContext().getSiteRoot(), subsite);
        return scopeFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateAsIso8601(Date date) {
        Class<CmsSearchUtil> clazz = CmsSearchUtil.class;
        synchronized (CmsSearchUtil.class) {
            if (DATEFORMAT_ISO_8601.getTimeZone() != TIMEZONE_UTC) {
                DATEFORMAT_ISO_8601.setTimeZone(TIMEZONE_UTC);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DATEFORMAT_ISO_8601.format(date);
        }
    }

    public static String getDateAsIso8601(long date) {
        if (date > Long.MIN_VALUE && date < Long.MAX_VALUE) {
            Date d_date = new Date(date);
            return CmsSearchUtil.getDateAsIso8601(d_date);
        }
        return null;
    }

    public static String getDateCreatedTimeRangeFilterQuery(String searchField, long startTime, long endTime) {
        String sStartTime = null;
        String sEndTime = null;
        if (startTime > Long.MIN_VALUE && startTime < Long.MAX_VALUE) {
            sStartTime = CmsSearchUtil.getDateAsIso8601(new Date(startTime));
        }
        if (endTime > Long.MIN_VALUE && endTime < Long.MAX_VALUE) {
            sEndTime = CmsSearchUtil.getDateAsIso8601(new Date(endTime));
        }
        String rangeString = CmsSearchUtil.getSolrRangeString(sStartTime, sEndTime);
        return String.format("%s:%s", searchField, rangeString);
    }

    public static List<String> getSearchRootsForScope(CmsGallerySearchScope scope, String siteParam, String subSiteParam) {
        String sharedFolder;
        ArrayList<String> result = new ArrayList<String>();
        if (scope == CmsGallerySearchScope.everything) {
            result.add("/");
            return result;
        }
        if (scope.isIncludeSite()) {
            result.add(siteParam);
        }
        if (scope.isIncludeSubSite()) {
            if (subSiteParam == null) {
                result.add(siteParam);
            } else {
                result.add(CmsStringUtil.joinPaths(siteParam, subSiteParam));
            }
        }
        if (scope.isIncludeShared() && (sharedFolder = OpenCms.getSiteManager().getSharedFolder()) != null) {
            result.add(sharedFolder);
        }
        return result;
    }

    public static String getSolrRangeString(String from, String to) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(from)) {
            from = "*";
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(to)) {
            to = "*";
        }
        return String.format("[%s TO %s]", from, to);
    }
}

