/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.extractors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.util.CmsStringUtil;

public class CmsExtractionResult
implements I_CmsExtractionResult,
Serializable {
    private static final long serialVersionUID = 1465447302192195154L;
    private Map<Locale, LinkedHashMap<String, String>> m_contentItems;
    private Collection<Locale> m_locales;
    private Locale m_defaultLocale;
    private Map<String, String> m_fieldMappings;
    private byte[] m_serializedVersion;

    public CmsExtractionResult(Locale defaultLocale, Map<Locale, LinkedHashMap<String, String>> multilingualContentItems, Map<String, String> fieldMappings) {
        this.m_defaultLocale = defaultLocale;
        this.m_contentItems = null != multilingualContentItems ? this.removeNullEntries(multilingualContentItems) : new HashMap(1);
        this.m_locales = new HashSet<Locale>();
        for (Locale locale : this.m_contentItems.keySet()) {
            if (null == locale) continue;
            this.m_locales.add(locale);
        }
        if (null == this.m_contentItems.get(this.m_defaultLocale)) {
            this.m_contentItems.put(this.m_defaultLocale, new LinkedHashMap());
        }
        this.m_fieldMappings = null != fieldMappings ? fieldMappings : new HashMap();
    }

    public CmsExtractionResult(String content) {
        this(content, null, null);
        this.m_contentItems.get(this.m_defaultLocale).put("__raw", content);
    }

    public CmsExtractionResult(String content, LinkedHashMap<String, String> contentItems) {
        this(content, contentItems, null);
    }

    public CmsExtractionResult(String content, LinkedHashMap<String, String> contentItems, Map<String, String> fieldMappings) {
        this.m_defaultLocale = null;
        this.m_locales = new HashSet<Locale>();
        this.m_contentItems = new LinkedHashMap<Locale, LinkedHashMap<String, String>>(1);
        this.m_fieldMappings = fieldMappings != null ? fieldMappings : new HashMap<String, String>();
        if (contentItems != null) {
            this.m_contentItems.put(this.m_defaultLocale, contentItems);
        } else {
            this.m_contentItems.put(this.m_defaultLocale, new LinkedHashMap());
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(content)) {
            this.m_contentItems.get(this.m_defaultLocale).put("__content", content);
        }
    }

    public static final CmsExtractionResult fromBytes(byte[] bytes) {
        Object obj = null;
        if (bytes != null) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                ObjectInputStream oin = new ObjectInputStream(in);
                obj = oin.readObject();
                oin.close();
            }
            catch (Exception in) {
                // empty catch block
            }
            if (obj instanceof CmsExtractionResult) {
                CmsExtractionResult result = (CmsExtractionResult)obj;
                result.m_serializedVersion = bytes;
                return result;
            }
        }
        return null;
    }

    @Override
    public byte[] getBytes() {
        if (this.m_serializedVersion != null) {
            return this.m_serializedVersion;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(512);
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(this);
            oout.close();
            this.m_serializedVersion = out.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_serializedVersion;
    }

    @Override
    public String getContent() {
        return this.m_contentItems.get(this.m_defaultLocale).get("__content");
    }

    @Override
    public String getContent(Locale locale) {
        Map localeItems = this.m_contentItems.get(locale);
        return null == localeItems ? null : (String)localeItems.get("__content");
    }

    @Override
    public LinkedHashMap<String, String> getContentItems() {
        return this.m_contentItems.get(this.m_defaultLocale);
    }

    @Override
    public LinkedHashMap<String, String> getContentItems(Locale locale) {
        LinkedHashMap localeItems = this.m_contentItems.get(locale);
        return null == localeItems ? new LinkedHashMap() : localeItems;
    }

    @Override
    public Locale getDefaultLocale() {
        return this.m_defaultLocale;
    }

    @Override
    public Map<String, String> getFieldMappings() {
        return this.m_fieldMappings;
    }

    @Override
    public Collection<Locale> getLocales() {
        return this.m_locales;
    }

    @Override
    public I_CmsExtractionResult merge(List<I_CmsExtractionResult> extractionResults) {
        Map<String, String> localeValues;
        HashMap<Locale, LinkedHashMap<String, String>> contentItems = new HashMap<Locale, LinkedHashMap<String, String>>(this.m_locales.size());
        for (Locale locale : this.m_locales) {
            LinkedHashMap<String, String> originalLocalValues = this.m_contentItems.get(locale);
            localeValues = new LinkedHashMap<String, String>(originalLocalValues);
            contentItems.put(locale, (LinkedHashMap<String, String>)localeValues);
        }
        HashMap<String, String> fieldMappings = new HashMap<String, String>(this.m_fieldMappings.size());
        for (String fieldMapping : this.m_fieldMappings.keySet()) {
            fieldMappings.put(fieldMapping, this.m_fieldMappings.get(fieldMapping));
        }
        for (Locale locale : this.m_locales) {
            localeValues = (Map)contentItems.get(locale);
            for (I_CmsExtractionResult result : extractionResults) {
                if (!result.getLocales().contains(locale)) continue;
                LinkedHashMap<String, String> resultLocaleValues = result.getContentItems(locale);
                for (String item : Arrays.asList(ITEMS_TO_MERGE)) {
                    localeValues = this.mergeItem(item, localeValues, resultLocaleValues);
                }
            }
        }
        return new CmsExtractionResult(this.m_defaultLocale, contentItems, fieldMappings);
    }

    @Override
    public void release() {
        if (!this.m_contentItems.isEmpty()) {
            this.m_contentItems.clear();
        }
        this.m_contentItems = null;
        this.m_serializedVersion = null;
    }

    private Map<String, String> mergeItem(String item, Map<String, String> localeValues, Map<String, String> resultLocaleValues) {
        if (resultLocaleValues.get(item) != null) {
            if (localeValues.get(item) != null) {
                localeValues.put(item, localeValues.get(item) + " " + resultLocaleValues.get(item));
            } else {
                localeValues.put(item, resultLocaleValues.get(item));
            }
        }
        return localeValues;
    }

    private Map<Locale, LinkedHashMap<String, String>> removeNullEntries(Map<Locale, LinkedHashMap<String, String>> multilingualContentItems) {
        for (Locale locale : multilingualContentItems.keySet()) {
            if (null != multilingualContentItems.get(locale)) continue;
            multilingualContentItems.put(locale, new LinkedHashMap());
        }
        return multilingualContentItems;
    }
}

