/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.document.DateTools;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.I_CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.search.Messages;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;

public class CmsSearchFieldMapping
implements I_CmsSearchFieldMapping {
    private static final String DATE_EXPIRED_DEFAULT_STR = "21000101";
    private static Date m_defaultDateExpired;
    private static final long serialVersionUID = 3016384419639743033L;
    private String m_defaultValue;
    private int m_hashCode;
    private String m_param;
    private CmsSearchFieldMappingType m_type;
    private boolean m_isLucene;

    public CmsSearchFieldMapping() {
    }

    public CmsSearchFieldMapping(boolean isLucene) {
        this();
        this.m_isLucene = isLucene;
    }

    public CmsSearchFieldMapping(CmsSearchFieldMappingType type, String param) {
        this();
        this.setType(type);
        this.setParam(param);
    }

    public CmsSearchFieldMapping(CmsSearchFieldMappingType type, String param, boolean isLucene) {
        this(type, param);
        this.m_isLucene = isLucene;
    }

    public static Date getDefaultDateExpired() throws ParseException {
        if (m_defaultDateExpired == null) {
            m_defaultDateExpired = DateTools.stringToDate((String)DATE_EXPIRED_DEFAULT_STR);
        }
        return m_defaultDateExpired;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof I_CmsSearchFieldMapping) {
            I_CmsSearchFieldMapping other = (I_CmsSearchFieldMapping)obj;
            return CmsStringUtil.isEqual(this.m_type, other.getType()) && CmsStringUtil.isEqual(this.m_param, other.getParam());
        }
        return false;
    }

    @Override
    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    @Override
    public String getParam() {
        return this.m_param;
    }

    @Override
    public String getStringValue(CmsObject cms, CmsResource res, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        String content = null;
        block4 : switch (this.getType().getMode()) {
            case 0: {
                if (extractionResult == null) break;
                content = extractionResult.getContent();
                break;
            }
            case 1: {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParam())) break;
                content = CmsProperty.get(this.getParam(), properties).getValue();
                break;
            }
            case 2: {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParam())) break;
                content = CmsProperty.get(this.getParam(), propertiesSearched).getValue();
                break;
            }
            case 3: {
                if (extractionResult == null || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParam())) break;
                String[] paramParts = this.getParam().split("\\|");
                LinkedHashMap<String, String> localizedContentItems = null;
                String xpath = null;
                if (paramParts.length > 1) {
                    OpenCms.getLocaleManager();
                    localizedContentItems = extractionResult.getContentItems(CmsLocaleManager.getLocale(paramParts[0].trim()));
                    xpath = paramParts[1].trim();
                } else {
                    localizedContentItems = extractionResult.getContentItems();
                    xpath = paramParts[0].trim();
                }
                content = this.getContentItemForXPath(localizedContentItems, xpath);
                break;
            }
            case 5: {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParam())) break;
                I_CmsResource.CmsResourceAttribute attribute = null;
                try {
                    attribute = I_CmsResource.CmsResourceAttribute.valueOf(this.getParam());
                }
                catch (Exception localizedContentItems) {
                    // empty catch block
                }
                if (attribute == null) break;
                switch (attribute) {
                    case dateContent: {
                        content = this.m_isLucene ? DateTools.timeToString((long)res.getDateContent(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND) : Long.toString(res.getDateContent());
                        break block4;
                    }
                    case dateCreated: {
                        content = this.m_isLucene ? DateTools.timeToString((long)res.getDateCreated(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND) : Long.toString(res.getDateCreated());
                        break block4;
                    }
                    case dateExpired: {
                        if (this.m_isLucene) {
                            long expirationDate = res.getDateExpired();
                            if (expirationDate == Long.MAX_VALUE) {
                                content = DATE_EXPIRED_DEFAULT_STR;
                                break block4;
                            }
                            content = DateTools.timeToString((long)expirationDate, (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
                            break block4;
                        }
                        content = Long.toString(res.getDateExpired());
                        break block4;
                    }
                    case dateLastModified: {
                        content = this.m_isLucene ? DateTools.timeToString((long)res.getDateLastModified(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND) : Long.toString(res.getDateLastModified());
                        break block4;
                    }
                    case dateReleased: {
                        content = this.m_isLucene ? DateTools.timeToString((long)res.getDateReleased(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND) : Long.toString(res.getDateReleased());
                        break block4;
                    }
                    case flags: {
                        content = String.valueOf(res.getFlags());
                        break block4;
                    }
                    case length: {
                        content = String.valueOf(res.getLength());
                        break block4;
                    }
                    case name: {
                        content = res.getName();
                        break block4;
                    }
                    case projectLastModified: {
                        try {
                            CmsProject project = cms.readProject(res.getProjectLastModified());
                            content = project.getName();
                        }
                        catch (Exception project) {}
                        break block4;
                    }
                    case resourceId: {
                        content = res.getResourceId().toString();
                        break block4;
                    }
                    case rootPath: {
                        content = res.getRootPath();
                        break block4;
                    }
                    case siblingCount: {
                        content = String.valueOf(res.getSiblingCount());
                        break block4;
                    }
                    case state: {
                        content = res.getState().toString();
                        break block4;
                    }
                    case structureId: {
                        content = res.getStructureId().toString();
                        break block4;
                    }
                    case typeId: {
                        content = String.valueOf(res.getTypeId());
                        break block4;
                    }
                    case userCreated: {
                        try {
                            CmsUser user = cms.readUser(res.getUserCreated());
                            content = user.getName();
                        }
                        catch (Exception user) {}
                        break block4;
                    }
                    case userLastModified: {
                        try {
                            CmsUser user = cms.readUser(res.getUserLastModified());
                            content = user.getName();
                        }
                        catch (Exception exception) {}
                        break block4;
                    }
                    case version: {
                        content = String.valueOf(res.getVersion());
                        break block4;
                    }
                }
                break;
            }
        }
        if (content == null) {
            content = this.getDefaultValue();
        }
        return content;
    }

    @Override
    public CmsSearchFieldMappingType getType() {
        return this.m_type;
    }

    public int hashCode() {
        if (this.m_hashCode == 0) {
            int hashCode = 73 * (this.m_type == null ? 29 : this.m_type.hashCode());
            if (this.m_param != null) {
                hashCode += this.m_param.hashCode();
            }
            this.m_hashCode = hashCode;
        }
        return this.m_hashCode;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = CmsStringUtil.isNotEmptyOrWhitespaceOnly(defaultValue) ? defaultValue.trim() : null;
    }

    @Override
    public void setParam(String param) {
        this.m_param = CmsStringUtil.isNotEmptyOrWhitespaceOnly(param) ? param.trim() : null;
    }

    @Override
    public void setType(CmsSearchFieldMappingType type) {
        this.m_type = type;
    }

    @Override
    public void setType(String type) {
        CmsSearchFieldMappingType mappingType = CmsSearchFieldMappingType.valueOf(type);
        if (mappingType == null) {
            throw new CmsRuntimeException(new CmsMessageContainer(Messages.get(), "ERR_FIELD_TYPE_UNKNOWN_1", type));
        }
        this.setType(mappingType);
    }

    private String getContentItemForXPath(Map<String, String> contentItems, String xpath) {
        if (contentItems.get(xpath) != null) {
            return contentItems.get(xpath);
        }
        TreeMap<List<Integer>, String> valueMap = new TreeMap<List<Integer>, String>(new Comparator<List<Integer>>(){

            @Override
            public int compare(List<Integer> l1, List<Integer> l2) {
                for (int i = 0; i < l1.size(); ++i) {
                    int numCompare = Integer.compare(l1.get(i), l2.get(i));
                    if (0 == numCompare) continue;
                    return numCompare;
                }
                return 0;
            }
        });
        for (Map.Entry<String, String> entry : contentItems.entrySet()) {
            if (!CmsXmlUtils.removeXpath(entry.getKey()).equals(xpath)) continue;
            String[] xPathParts = entry.getKey().split("/");
            ArrayList<Integer> indexes = new ArrayList<Integer>(xPathParts.length);
            for (String xPathPart : Arrays.asList(xPathParts)) {
                if (xPathPart.isEmpty()) continue;
                indexes.add(CmsXmlUtils.getXpathIndexInt(xPathPart));
            }
            valueMap.put(indexes, entry.getValue());
        }
        StringBuffer result = new StringBuffer();
        for (String value : valueMap.values()) {
            result.append(value);
            result.append("\n");
        }
        return result.length() > 1 ? result.toString().substring(0, result.length() - 1) : null;
    }
}

