/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.security.Messages;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.I_CmsGroupNameTranslation;

public abstract class CmsPrincipal
implements I_CmsPrincipal,
Comparable<I_CmsPrincipal> {
    protected String m_description;
    protected int m_flags;
    protected CmsUUID m_id;
    protected String m_name;

    protected CmsPrincipal() {
    }

    public static List<? extends CmsPrincipal> filterCoreFlag(List<? extends CmsPrincipal> principals, int flag) {
        Iterator<? extends CmsPrincipal> it = principals.iterator();
        while (it.hasNext()) {
            CmsPrincipal p = it.next();
            if (p.getFlags() <= 65536 || (p.getFlags() & flag) == flag) continue;
            it.remove();
        }
        return principals;
    }

    public static List<CmsGroup> filterCoreGroups(List<CmsGroup> groups) {
        Iterator<CmsGroup> it = groups.iterator();
        while (it.hasNext()) {
            CmsGroup p = it.next();
            if (p.getFlags() <= 65536) continue;
            it.remove();
        }
        return groups;
    }

    public static List<CmsUser> filterCoreUsers(List<CmsUser> users) {
        Iterator<CmsUser> it = users.iterator();
        while (it.hasNext()) {
            I_CmsPrincipal p = it.next();
            if (p.getFlags() <= 65536) continue;
            it.remove();
        }
        return users;
    }

    public static List<? extends CmsPrincipal> filterFlag(List<? extends CmsPrincipal> principals, int flag) {
        Iterator<? extends CmsPrincipal> it = principals.iterator();
        while (it.hasNext()) {
            CmsPrincipal p = it.next();
            if ((p.getFlags() & flag) == flag) continue;
            it.remove();
        }
        return principals;
    }

    public static String getPrefixedGroup(String name) {
        StringBuffer result = new StringBuffer(name.length() + 10);
        result.append("GROUP");
        result.append('.');
        result.append(name);
        return result.toString();
    }

    public static String getPrefixedUser(String name) {
        StringBuffer result = new StringBuffer(name.length() + 10);
        result.append("USER");
        result.append('.');
        result.append(name);
        return result.toString();
    }

    public static I_CmsPrincipal readPrefixedPrincipal(CmsObject cms, String name) throws CmsException {
        if (CmsGroup.hasPrefix(name)) {
            return cms.readGroup(CmsGroup.removePrefix(name));
        }
        if (CmsUser.hasPrefix(name)) {
            return cms.readUser(CmsUser.removePrefix(name));
        }
        throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_INVALID_PRINCIPAL_1", name));
    }

    public static I_CmsPrincipal readPrincipal(CmsObject cms, CmsUUID id) throws CmsException {
        try {
            return cms.readUser(id);
        }
        catch (CmsException cmsException) {
            try {
                return cms.readGroup(id);
            }
            catch (CmsException cmsException2) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_INVALID_PRINCIPAL_1", id));
            }
        }
    }

    public static I_CmsPrincipal readPrincipal(CmsObject cms, String type, String name) throws CmsException {
        if (CmsStringUtil.isNotEmpty(type)) {
            String upperCaseType = type.toUpperCase();
            if ("GROUP".equals(upperCaseType)) {
                return cms.readGroup(name);
            }
            if ("USER".equals(upperCaseType)) {
                return cms.readUser(name);
            }
        }
        throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_INVALID_PRINCIPAL_TYPE_2", type, name));
    }

    public static I_CmsPrincipal readPrincipalIncludingHistory(CmsObject cms, CmsUUID id) throws CmsException {
        try {
            return cms.readUser(id);
        }
        catch (CmsException cmsException) {
            try {
                return cms.readGroup(id);
            }
            catch (CmsException cmsException2) {
                try {
                    return cms.readHistoryPrincipal(id);
                }
                catch (CmsException cmsException3) {
                    throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_INVALID_PRINCIPAL_1", id));
                }
            }
        }
    }

    @Override
    public int compareTo(I_CmsPrincipal obj) {
        if (this == obj || this.equals(obj)) {
            return 0;
        }
        return this.getName().compareTo(obj.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof I_CmsPrincipal && this.m_id != null) {
            return this.m_id.equals(((I_CmsPrincipal)obj).getId());
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public String getDisplayName(CmsObject cms, Locale locale) throws CmsException {
        return Messages.get().getBundle(locale).key("GUI_PRINCIPAL_DISPLAY_NAME_2", this.getSimpleName(), OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, this.getOuFqn()).getDisplayName(locale));
    }

    public String getDisplayName(CmsObject cms, Locale locale, I_CmsGroupNameTranslation translation) throws CmsException {
        if (!this.isGroup() || translation == null) {
            return this.getDisplayName(cms, locale);
        }
        return Messages.get().getBundle(locale).key("GUI_PRINCIPAL_DISPLAY_NAME_2", translation.translateGroupName(this.getName(), false), OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, this.getOuFqn()).getDisplayName(locale));
    }

    @Override
    public int getFlags() {
        return this.m_flags;
    }

    @Override
    public CmsUUID getId() {
        return this.m_id;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getOuFqn() {
        return CmsOrganizationalUnit.getParentFqn(this.m_name);
    }

    @Override
    public String getPrefixedName() {
        if (this.isUser()) {
            return CmsPrincipal.getPrefixedUser(this.getName());
        }
        if (this.isGroup()) {
            return CmsPrincipal.getPrefixedGroup(this.getName());
        }
        return this.getName();
    }

    @Override
    public String getSimpleName() {
        return CmsOrganizationalUnit.getSimpleName(this.m_name);
    }

    @Override
    public int hashCode() {
        if (this.m_id != null) {
            return this.m_id.hashCode();
        }
        return CmsUUID.getNullUUID().hashCode();
    }

    @Override
    public boolean isEnabled() {
        return (this.getFlags() & 1) == 0;
    }

    @Override
    public boolean isGroup() {
        return this instanceof CmsGroup;
    }

    @Override
    public boolean isUser() {
        return this instanceof CmsUser;
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.setFlags(this.getFlags() ^ 1);
        }
    }

    @Override
    public void setFlags(int value) {
        this.m_flags = value;
    }

    @Override
    public void setName(String name) {
        this.checkName(CmsOrganizationalUnit.getSimpleName(name));
        this.m_name = name;
    }
}

