/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.detailpage.I_CmsDetailPageFinder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsStaticResourceHandler;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.staticexport.I_CmsLinkSubstitutionHandler;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;

public class CmsDefaultLinkSubstitutionHandler
implements I_CmsLinkSubstitutionHandler {
    public static final String ATTR_IS_IMAGE_LINK = "IS_IMAGE_LINK";
    public static final String DONT_USE_CURRENT_SITE_FOR_WORKPLACE_REQUESTS = "DONT_USE_CURRENT_SITE_FOR_WORKPLACE_REQUESTS";
    private static final Log LOG = CmsLog.getLog(CmsDefaultLinkSubstitutionHandler.class);
    public static final String OVERRIDE_SITEROOT_PREFIX = "OVERRIDE_SITEROOT:";

    @Override
    public String getLink(CmsObject cms, String link, String siteRoot, boolean forceSecure) {
        return this.getLink(cms, link, siteRoot, null, forceSecure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLink(CmsObject cms, String link, String siteRoot, String targetDetailPage, boolean forceSecure) {
        CmsResource detailContent;
        String detailPage;
        String originalVfsName;
        String targetSiteRoot;
        CmsSite targetSite;
        CmsSite currentSite;
        boolean useRelativeLinks;
        String uriBaseName;
        String resultLink;
        String anchor;
        String parameters;
        String vfsName;
        String overrideSiteRoot;
        String absoluteLink;
        block47: {
            if (CmsStringUtil.isEmpty(link)) {
                return "";
            }
            if (CmsStaticResourceHandler.isStaticResourceUri(link)) {
                return CmsWorkplace.getStaticResourceUri(link);
            }
            absoluteLink = CmsLinkManager.getAbsoluteUri(link, cms.getRequestContext().getUri());
            overrideSiteRoot = null;
            int pos = absoluteLink.indexOf(63);
            if (pos >= 0) {
                vfsName = absoluteLink.substring(0, pos);
                parameters = absoluteLink.substring(pos);
            } else {
                vfsName = absoluteLink;
                parameters = null;
            }
            anchor = null;
            pos = vfsName.indexOf(35);
            if (pos >= 0) {
                anchor = vfsName.substring(pos);
                vfsName = vfsName.substring(0, pos);
            }
            resultLink = null;
            uriBaseName = null;
            useRelativeLinks = false;
            currentSite = OpenCms.getSiteManager().getCurrentSite(cms);
            targetSite = null;
            if (CmsStringUtil.isNotEmpty(siteRoot)) {
                targetSite = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
            }
            if (targetSite == null) {
                targetSite = currentSite;
            }
            targetSiteRoot = targetSite.getSiteRoot();
            originalVfsName = vfsName;
            detailPage = null;
            detailContent = null;
            try {
                String rootVfsName = !vfsName.startsWith(targetSiteRoot) && !vfsName.startsWith("/system/") && !OpenCms.getSiteManager().startsWithShared(vfsName) ? CmsStringUtil.joinPaths(targetSiteRoot, vfsName) : vfsName;
                if (!rootVfsName.startsWith("/system/workplace/")) {
                    I_CmsDetailPageFinder finder = OpenCms.getADEManager().getDetailPageFinder();
                    detailPage = finder.getDetailPage(cms, rootVfsName, cms.getRequestContext().getUri(), targetDetailPage);
                }
                if (detailPage == null) break block47;
                CmsSite detailPageSite = OpenCms.getSiteManager().getSiteForRootPath(detailPage);
                if (detailPageSite != null) {
                    targetSite = detailPageSite;
                    overrideSiteRoot = targetSiteRoot = targetSite.getSiteRoot();
                    if (!(detailPage = detailPage.substring(targetSiteRoot.length())).startsWith("/")) {
                        detailPage = "/" + detailPage;
                    }
                }
                String originalSiteRoot = cms.getRequestContext().getSiteRoot();
                try {
                    CmsResource element;
                    cms.getRequestContext().setSiteRoot("");
                    detailContent = element = cms.readResource(rootVfsName, CmsResourceFilter.IGNORE_EXPIRATION);
                    Locale locale = cms.getRequestContext().getLocale();
                    List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales();
                    vfsName = CmsStringUtil.joinPaths(detailPage, cms.getDetailName(element, locale, defaultLocales), "/");
                }
                catch (CmsVfsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                finally {
                    cms.getRequestContext().setSiteRoot(originalSiteRoot);
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        String serverPrefix = targetSite != currentSite ? targetSite.getUrl() : "";
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            String detailPagePart;
            String cacheKey;
            CmsStaticExportManager exportManager = OpenCms.getStaticExportManager();
            String oriUri = cms.getRequestContext().getUri();
            if (exportManager.relativeLinksInExport(cms.getRequestContext().getSiteRoot() + oriUri)) {
                String cacheKey2 = exportManager.getCacheKey(targetSiteRoot, oriUri);
                uriBaseName = exportManager.getCachedOnlineLink(cacheKey2);
                if (uriBaseName == null) {
                    if (exportManager.isExportLink(cms, oriUri)) {
                        uriBaseName = exportManager.getRfsName(cms, oriUri);
                    } else {
                        CmsPair<String, String> uriParamPair = this.addVfsPrefix(cms, oriUri, targetSite, parameters);
                        uriBaseName = uriParamPair.getFirst();
                        parameters = uriParamPair.getSecond();
                    }
                    exportManager.cacheOnlineLink(cacheKey2, uriBaseName);
                }
                useRelativeLinks = uriBaseName.startsWith(exportManager.getRfsPrefix(cms.getRequestContext().getSiteRoot() + oriUri));
            }
            if ((resultLink = exportManager.getCachedOnlineLink(cacheKey = this.generateCacheKey(cms, targetSiteRoot, detailPagePart = detailPage == null ? "" : detailPage + ":", absoluteLink))) == null) {
                String storedSiteRoot = cms.getRequestContext().getSiteRoot();
                try {
                    cms.getRequestContext().setSiteRoot(targetSite.getSiteRoot());
                    if (exportManager.isExportLink(cms, vfsName)) {
                        parameters = this.prepareExportParameters(cms, vfsName, parameters);
                        resultLink = exportManager.getRfsName(cms, vfsName, parameters, targetDetailPage);
                        parameters = null;
                    } else {
                        CmsPair<String, String> uriParamPair = this.addVfsPrefix(cms, vfsName, targetSite, parameters);
                        resultLink = uriParamPair.getFirst();
                        parameters = uriParamPair.getSecond();
                        if (parameters != null) {
                            resultLink = resultLink.concat(parameters);
                        }
                    }
                }
                finally {
                    cms.getRequestContext().setSiteRoot(storedSiteRoot);
                }
                exportManager.cacheOnlineLink(cacheKey, resultLink);
            }
            if ((targetSite.hasSecureServer() || currentSite.hasSecureServer()) && !vfsName.startsWith("/system/")) {
                int imageId;
                int linkType;
                block49: {
                    linkType = -1;
                    try {
                        linkType = cms.readResource(originalVfsName).getTypeId();
                    }
                    catch (CmsException e) {
                        if (!LOG.isInfoEnabled()) break block49;
                        String message = Messages.get().getBundle().key("LOG_RESOURCE_ACESS_ERROR_3", vfsName, cms.getRequestContext().getCurrentUser().getName(), cms.getRequestContext().getSiteRoot());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)message, (Throwable)e);
                        }
                        LOG.info((Object)message);
                    }
                }
                try {
                    imageId = OpenCms.getResourceManager().getResourceType(CmsResourceTypeImage.getStaticTypeName()).getTypeId();
                }
                catch (CmsLoaderException e1) {
                    LOG.warn((Object)e1.getLocalizedMessage(), (Throwable)e1);
                    imageId = CmsResourceTypeImage.getStaticTypeId();
                }
                boolean hasIsImageLinkAttr = Boolean.parseBoolean("" + cms.getRequestContext().getAttribute(ATTR_IS_IMAGE_LINK));
                if (linkType != imageId && !hasIsImageLinkAttr) {
                    boolean secureRequest = cms.getRequestContext().isSecureRequest() || exportManager.isSecureLink(cms, oriUri);
                    boolean secureLink = detailContent == null ? this.isSecureLink(cms, vfsName, targetSite, secureRequest) : this.isDetailPageLinkSecure(cms, detailPage, detailContent, targetSite, secureRequest);
                    if (secureLink && (forceSecure || !secureRequest)) {
                        serverPrefix = targetSite.getSecureUrl();
                    } else if (!secureLink && secureRequest) {
                        serverPrefix = targetSite.getUrl();
                    }
                }
            }
            if (useRelativeLinks && CmsStringUtil.isEmpty(serverPrefix)) {
                if (cms.getRequestContext().getDetailContentId() != null) {
                    uriBaseName = CmsStringUtil.joinPaths(CmsResource.getFolderPath(uriBaseName), cms.getRequestContext().getDetailContentId().toString() + "/index.html");
                }
                resultLink = CmsLinkManager.getRelativeUri(uriBaseName, resultLink);
            }
        } else {
            if (OpenCms.getRunLevel() >= 3) {
                CmsPair<String, String> uriParamPair = this.addVfsPrefix(cms, vfsName, targetSite, parameters);
                resultLink = uriParamPair.getFirst();
                parameters = uriParamPair.getSecond();
            }
            if (parameters != null && resultLink != null) {
                resultLink = resultLink.concat(parameters);
            }
        }
        if (anchor != null && resultLink != null) {
            resultLink = resultLink.concat(anchor);
        }
        if (overrideSiteRoot != null) {
            cms.getRequestContext().setAttribute(OVERRIDE_SITEROOT_PREFIX + resultLink, overrideSiteRoot);
        }
        return serverPrefix.concat(resultLink);
    }

    @Override
    public String getRootPath(CmsObject cms, String targetUri, String basePath) {
        String result = this.getSimpleRootPath(cms, targetUri, basePath);
        String detailRootPath = this.getDetailRootPath(cms, result);
        if (detailRootPath != null) {
            result = detailRootPath;
        }
        return result;
    }

    protected CmsPair<String, String> addVfsPrefix(CmsObject cms, String vfsName, CmsSite targetSite, String parameters) {
        return new CmsPair<String, String>(OpenCms.getStaticExportManager().getVfsPrefix().concat(vfsName), parameters);
    }

    protected String generateCacheKey(CmsObject cms, String targetSiteRoot, String detailPagePart, String absoluteLink) {
        return cms.getRequestContext().getSiteRoot() + ":" + targetSiteRoot + ":" + detailPagePart + absoluteLink;
    }

    protected String getRootPathForSite(CmsObject cms, String path, String siteRoot, boolean isRootPath) {
        if (isRootPath || siteRoot == null) {
            return CmsStringUtil.joinPaths("/", path);
        }
        return cms.getRequestContext().addSiteRoot(siteRoot, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSimpleRootPath(CmsObject cms, String targetUri, String basePath) {
        String path;
        URI uri;
        if (cms == null) {
            return targetUri;
        }
        String suffix = "";
        try {
            uri = new URI(targetUri);
            path = uri.getPath();
            suffix = this.getSuffix(uri);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_MALFORMED_URI_1", targetUri), (Throwable)e);
            }
            return null;
        }
        if (uri.isOpaque()) {
            return null;
        }
        if (CmsLinkManager.isWorkplaceUri(uri)) {
            return null;
        }
        if (CmsStaticResourceHandler.isStaticResourceUri(uri)) {
            return CmsStringUtil.joinPaths("/handleStatic", CmsStaticResourceHandler.removeStaticResourcePrefix(path));
        }
        CmsStaticExportManager exportManager = OpenCms.getStaticExportManager();
        if (exportManager.isValidRfsName(path)) {
            String originalSiteRoot = cms.getRequestContext().getSiteRoot();
            String vfsName = null;
            try {
                cms.getRequestContext().setSiteRoot("");
                vfsName = exportManager.getVfsName(cms, path);
                if (vfsName != null) {
                    String string = vfsName;
                    return string;
                }
            }
            finally {
                cms.getRequestContext().setSiteRoot(originalSiteRoot);
            }
        }
        if (uri.isAbsolute()) {
            CmsSiteMatcher targetMatcher = new CmsSiteMatcher(targetUri);
            if (OpenCms.getSiteManager().isMatching(targetMatcher) || targetMatcher.equals(cms.getRequestContext().getRequestMatcher())) {
                boolean isWorkplaceServer;
                path = CmsLinkManager.removeOpenCmsContext(path);
                boolean bl = isWorkplaceServer = OpenCms.getSiteManager().isWorkplaceRequest(targetMatcher) || targetMatcher.equals(cms.getRequestContext().getRequestMatcher());
                if (isWorkplaceServer) {
                    String selectedPath;
                    String targetSiteRoot = OpenCms.getSiteManager().getSiteRoot(path);
                    if (targetSiteRoot != null) {
                        selectedPath = this.getRootPathForSite(cms, path, targetSiteRoot, true);
                    } else {
                        selectedPath = this.getRootPathForSite(cms, path, cms.getRequestContext().getSiteRoot(), false);
                        String pathForMatchedSite = this.getRootPathForSite(cms, path, OpenCms.getSiteManager().matchSite(targetMatcher).getSiteRoot(), false);
                        String originalSiteRoot = cms.getRequestContext().getSiteRoot();
                        try {
                            cms.getRequestContext().setSiteRoot("");
                            if (!cms.existsResource(selectedPath, CmsResourceFilter.ALL) && cms.existsResource(pathForMatchedSite, CmsResourceFilter.ALL)) {
                                selectedPath = pathForMatchedSite;
                            }
                        }
                        finally {
                            cms.getRequestContext().setSiteRoot(originalSiteRoot);
                        }
                    }
                    return selectedPath + suffix;
                }
                return this.getRootPathForSite(cms, path + suffix, OpenCms.getSiteManager().matchSite(targetMatcher).getSiteRoot(), false);
            }
            return null;
        }
        String context = OpenCms.getSystemInfo().getOpenCmsContext();
        String vfsPrefix = OpenCms.getStaticExportManager().getVfsPrefix();
        if (context != null && (path.startsWith(context + "/") || path.startsWith(vfsPrefix + "/"))) {
            path = CmsLinkManager.removeOpenCmsContext(path);
            String targetSiteRoot = this.getTargetSiteRoot(cms, path, basePath);
            return this.getRootPathForSite(cms, path + suffix, targetSiteRoot, targetSiteRoot != null && path.startsWith(targetSiteRoot));
        }
        if (CmsStringUtil.isNotEmpty(path) && path.charAt(0) != '/') {
            if (basePath != null) {
                int pos = path.indexOf("../../galleries/pics/");
                if (pos >= 0) {
                    return "/system/" + path.substring(pos + 6) + suffix;
                }
                String absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().addSiteRoot(basePath));
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
                absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().getSiteRoot() + "/system/workplace/editors/");
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
                absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().getSiteRoot() + "/system/workplace/editors/" + "xmlcontent/");
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
            }
            return null;
        }
        if (CmsStringUtil.isNotEmpty(path)) {
            String targetSiteRoot = this.getTargetSiteRoot(cms, path, basePath);
            return this.getRootPathForSite(cms, path + suffix, targetSiteRoot, targetSiteRoot != null && path.startsWith(targetSiteRoot));
        }
        return suffix;
    }

    protected boolean isDetailPageLinkSecure(CmsObject cms, String detailPage, CmsResource detailContent, CmsSite targetSite, boolean secureRequest) {
        boolean result = false;
        CmsStaticExportManager exportManager = OpenCms.getStaticExportManager();
        try {
            CmsResource defaultFile;
            cms = OpenCms.initCmsObject(cms);
            if (targetSite.getSiteRoot() != null) {
                cms.getRequestContext().setSiteRoot(targetSite.getSiteRoot());
            }
            if ((defaultFile = cms.readDefaultFile(detailPage)) != null) {
                result = exportManager.isSecureLink(cms, defaultFile.getRootPath(), "", secureRequest);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while checking whether detail page link should be secure: " + e.getLocalizedMessage()), (Throwable)e);
        }
        return result;
    }

    protected boolean isSecureLink(CmsObject cms, String vfsName, CmsSite targetSite, boolean secureRequest) {
        return OpenCms.getStaticExportManager().isSecureLink(cms, vfsName, targetSite.getSiteRoot(), secureRequest);
    }

    protected String prepareExportParameters(CmsObject cms, String vfsName, String parameters) {
        return parameters;
    }

    String getSuffix(URI uri) {
        String fragment = uri.getFragment();
        fragment = fragment != null ? "#" + fragment : "";
        String query = uri.getRawQuery();
        query = query != null ? "?" + query : "";
        return query.concat(fragment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDetailRootPath(CmsObject cms, String result) {
        if (result == null) {
            return null;
        }
        try {
            URI uri = new URI(result);
            String path = uri.getPath();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(path)) return null;
            if (!OpenCms.getADEManager().isInitialized()) {
                return null;
            }
            String name = CmsFileUtil.removeTrailingSeparator(CmsResource.getName(path));
            CmsUUID detailId = OpenCms.getADEManager().getDetailIdCache(cms.getRequestContext().getCurrentProject().isOnlineProject()).getDetailId(name);
            if (detailId == null) {
                return null;
            }
            String origSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot("");
                if (cms.existsResource(path)) {
                    String string = null;
                    return string;
                }
            }
            finally {
                cms.getRequestContext().setSiteRoot(origSiteRoot);
            }
            CmsResource detailResource = cms.readResource(detailId, CmsResourceFilter.ALL);
            return detailResource.getRootPath() + this.getSuffix(uri);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private String getTargetSiteRoot(CmsObject cms, String path, String basePath) {
        if (OpenCms.getSiteManager().startsWithShared(path) || path.startsWith("/system/")) {
            return null;
        }
        String targetSiteRoot = OpenCms.getSiteManager().getSiteRoot(path);
        if (targetSiteRoot == null && basePath != null) {
            targetSiteRoot = OpenCms.getSiteManager().getSiteRoot(basePath);
        }
        if (targetSiteRoot == null) {
            targetSiteRoot = cms.getRequestContext().getSiteRoot();
        }
        return targetSiteRoot;
    }
}

