/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.BooleanUtils;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;

public class CmsLinkTable {
    private static final String LINK_PREFIX = "link";
    public static final Pattern LINK_PATTERN = Pattern.compile("^(.*?)([0-9]*)$");
    private Map<String, CmsLink> m_linkTable = new TreeMap<String, CmsLink>(new LinkKeyComparator());

    public CmsLink addLink(CmsLink link) {
        this.m_linkTable.put(link.getName(), link);
        return link;
    }

    public CmsLink addLink(CmsRelationType type, String targetUri, boolean internal) {
        CmsLink link = new CmsLink(LINK_PREFIX + this.m_linkTable.size(), type, targetUri, internal);
        this.m_linkTable.put(link.getName(), link);
        return link;
    }

    public CmsLink getLink(String name) {
        return this.m_linkTable.get(name);
    }

    public boolean isEmpty() {
        return this.m_linkTable.isEmpty();
    }

    public Iterator<CmsLink> iterator() {
        return this.m_linkTable.values().iterator();
    }

    public int size() {
        return this.m_linkTable.size();
    }

    public static class LinkKeyComparator
    implements Comparator<String> {
        @Override
        public int compare(String a, String b) {
            if (a == null || b == null) {
                return BooleanUtils.toInteger((b == null ? 1 : 0) != 0) - BooleanUtils.toInteger((a == null ? 1 : 0) != 0);
            }
            Matcher matcherA = LINK_PATTERN.matcher(a);
            Matcher matcherB = LINK_PATTERN.matcher(b);
            matcherA.find();
            matcherB.find();
            String nameA = matcherA.group(1);
            int indexA = Integer.parseInt("0" + matcherA.group(2));
            String nameB = matcherB.group(1);
            int indexB = Integer.parseInt("0" + matcherB.group(2));
            int result = ComparisonChain.start().compare((Comparable)((Object)nameA), (Comparable)((Object)nameB)).compare(indexA, indexB).compare((Comparable)((Object)a), (Comparable)((Object)b)).result();
            return result;
        }
    }
}

