/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;

public class CmsStaticExportExportRule {
    private String m_description;
    private List<String> m_exportResources;
    private List<Pattern> m_modifiedResources;
    private String m_name;

    public CmsStaticExportExportRule(String name, String description) {
        this.m_name = name;
        this.m_description = description;
        this.m_exportResources = new ArrayList<String>();
        this.m_modifiedResources = new ArrayList<Pattern>();
    }

    public CmsStaticExportExportRule(String name, String description, List<Pattern> modifiedResources, List<String> exportResourcePatterns) {
        this(name, description);
        this.m_modifiedResources.addAll(modifiedResources);
        this.m_exportResources.addAll(exportResourcePatterns);
    }

    public void addExportResourcePattern(String exportResource) {
        this.m_exportResources.add(exportResource);
    }

    public void addModifiedResource(String modifiedRegex) {
        this.m_modifiedResources.add(Pattern.compile(modifiedRegex));
    }

    public String getDescription() {
        return this.m_description;
    }

    public List<String> getExportResourcePatterns() {
        return Collections.unmodifiableList(this.m_exportResources);
    }

    public Set<CmsPublishedResource> getExportResources(CmsObject cms) throws CmsException {
        HashSet<CmsPublishedResource> resources = new HashSet<CmsPublishedResource>(128);
        for (String exportRes : this.m_exportResources) {
            if (!cms.existsResource(exportRes)) continue;
            CmsResource res = cms.readResource(exportRes);
            resources.add(new CmsPublishedResource(res));
            if (!res.isFolder()) continue;
            List<CmsResource> vfsResources = cms.readResources(exportRes, CmsResourceFilter.ALL.addExcludeFlags(512));
            for (CmsResource vfsResource : vfsResources) {
                CmsPublishedResource resource = new CmsPublishedResource(vfsResource);
                resources.add(resource);
            }
        }
        return resources;
    }

    public List<Pattern> getModifiedResources() {
        return Collections.unmodifiableList(this.m_modifiedResources);
    }

    public String getName() {
        return this.m_name;
    }

    public Set<CmsPublishedResource> getRelatedResources(CmsObject cms, CmsPublishedResource publishedResource) throws CmsException {
        if (this.match(publishedResource.getRootPath())) {
            return this.getExportResources(cms);
        }
        return null;
    }

    public boolean match(String vfsName) {
        for (int j = 0; j < this.m_modifiedResources.size(); ++j) {
            Pattern pattern = this.m_modifiedResources.get(j);
            if (!pattern.matcher(vfsName).matches()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(this.getClass().getName());
        ret.append(":[");
        ret.append("name: ").append(this.m_name).append("; ");
        ret.append("description: ").append(this.m_description).append("; ");
        ret.append("modified patterns: ").append(this.m_modifiedResources).append("; ");
        ret.append("export resources: ").append(this.m_exportResources).append("; ");
        return ret.append("]").toString();
    }
}

