/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsCategoriesDialogAction
extends A_CmsWorkplaceAction {
    public static final String ACTION_ID = "categories";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.DEFAULT);

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        if (!this.hasBlockingLocks(context)) {
            CmsGwtDialogExtension extension = new CmsGwtDialogExtension(A_CmsUI.get(), new I_CmsUpdateListener<String>(){

                @Override
                public void onUpdate(List<String> updatedItems) {
                    ArrayList ids = Lists.newArrayList();
                    for (String item : updatedItems) {
                        ids.add(new CmsUUID(item));
                    }
                    context.finish(ids);
                }
            });
            extension.openCategories(context.getResources().get(0));
        }
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getTitle() {
        return this.getWorkplaceMessage("GUI_EXPLORER_CONTEXT_CATEGORIES_0");
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return VISIBILITY.getVisibility(cms, resources);
    }
}

