/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsEditPropertyContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsEditPropertyAction
extends A_CmsWorkplaceAction {
    public static final String ACTION_ID = "edit_";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.DEFAULT);
    private CmsResourceTableProperty m_propertyId;
    private String m_titleKey;

    public CmsEditPropertyAction(CmsResourceTableProperty propertyId, String titleKey) {
        this.m_propertyId = propertyId;
        this.m_titleKey = titleKey;
    }

    @Override
    public void executeAction(I_CmsDialogContext context) {
        if (!this.hasBlockingLocks(context)) {
            ((I_CmsEditPropertyContext)((Object)context)).editProperty(this.m_propertyId);
        }
    }

    @Override
    public String getId() {
        return ACTION_ID + this.m_propertyId.getId();
    }

    @Override
    public String getTitle() {
        return this.getWorkplaceMessage(this.m_titleKey);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return VISIBILITY.getVisibility(cms, resources);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        if (!(context instanceof I_CmsEditPropertyContext) || !((I_CmsEditPropertyContext)((Object)context)).isPropertyEditable(this.m_propertyId)) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        return this.getVisibility(context.getCms(), context.getResources());
    }
}

