/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.vaadin.ui.Component;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleGroup;
import org.opencms.i18n.CmsLocaleGroupService;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.ui.sitemap.CmsLocaleLinkTargetSelectionDialog;
import org.opencms.ui.sitemap.I_CmsLocaleCompareContext;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsLinkLocaleVariantAction
extends A_CmsWorkplaceAction {
    public static final String ACTION_ID = "linklocale";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.DEFAULT_DEFAULTFILE);
    private static final Log LOG = CmsLog.getLog(CmsLinkLocaleVariantAction.class);

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        try {
            CmsResource resource = context.getResources().get(0);
            CmsLocaleGroupService groupService = context.getCms().getLocaleGroupService();
            final CmsResource localizationRoot = groupService.findLocalizationRoot(resource);
            final CmsLocaleGroup localeGroup = groupService.readLocaleGroup(localizationRoot);
            CmsLocaleLinkTargetSelectionDialog dlg = new CmsLocaleLinkTargetSelectionDialog(context, new I_CmsLocaleCompareContext(){

                @Override
                public Locale getComparisonLocale() {
                    return OpenCms.getLocaleManager().getDefaultLocale(context.getCms(), this.getRoot());
                }

                @Override
                public CmsLocaleGroup getLocaleGroup() {
                    return localeGroup;
                }

                @Override
                public CmsResource getRoot() {
                    return localizationRoot;
                }

                @Override
                public Locale getRootLocale() {
                    return OpenCms.getLocaleManager().getDefaultLocale(context.getCms(), this.getRoot());
                }

                @Override
                public void refreshAll() {
                }
            });
            String title = CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_LINK_LOCALE_VARIANT_0", new Object[0]);
            context.start(title, (Component)dlg);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            context.error(e);
        }
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getTitle() {
        return CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_LINK_LOCALE_VARIANT_0", new Object[0]);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        if (resources.size() > 0) {
            CmsResource resource = resources.get(0);
            if (cms.getLocaleGroupService().getMainLocale(resource.getRootPath()) == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
        }
        return VISIBILITY.getVisibility(cms, resources);
    }
}

