/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.Locale;
import org.opencms.ui.apps.CmsAppCategoryNode;
import org.opencms.ui.apps.I_CmsAppButtonProvider;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;

public class CmsAppHierarchyPanel
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private HorizontalLayout m_appPanel = new HorizontalLayout();
    private I_CmsAppButtonProvider m_appButtonProvider;

    public CmsAppHierarchyPanel(I_CmsAppButtonProvider buttonProvider) {
        this.m_appPanel.addStyleName("wrapping");
        this.addComponent((Component)this.m_appPanel);
        this.setMargin(true);
        this.setSpacing(true);
        this.m_appButtonProvider = buttonProvider;
    }

    public void addChild(String label, CmsAppHierarchyPanel child) {
        Panel panel = new Panel();
        panel.setCaption(label);
        panel.setContent((Component)child);
        this.addComponent((Component)panel);
    }

    public void fill(CmsAppCategoryNode rootNode, Locale locale) {
        for (I_CmsWorkplaceAppConfiguration appConfig : rootNode.getAppConfigurations()) {
            this.m_appPanel.addComponent(this.m_appButtonProvider.createAppButton(appConfig));
        }
        for (CmsAppCategoryNode childNode : rootNode.getChildren()) {
            CmsAppHierarchyPanel childPanel = new CmsAppHierarchyPanel(this.m_appButtonProvider);
            this.addChild(childNode.getCategory().getName(locale), childPanel);
            childPanel.fill(childNode, locale);
        }
    }
}

