/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsAppButtonProvider;
import org.opencms.ui.apps.I_CmsHasAppLaunchCommand;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;

public class CmsDefaultAppButtonProvider
implements I_CmsAppButtonProvider {
    public static Component createAppButton(CmsObject cms, final I_CmsWorkplaceAppConfiguration appConfig, Locale locale) {
        Button button = CmsDefaultAppButtonProvider.createAppIconButton(appConfig, locale);
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (appConfig instanceof I_CmsHasAppLaunchCommand && ((I_CmsHasAppLaunchCommand)((Object)appConfig)).getAppLaunchCommand() != null) {
                    ((I_CmsHasAppLaunchCommand)((Object)appConfig)).getAppLaunchCommand().run();
                } else {
                    CmsAppWorkplaceUi ui = (CmsAppWorkplaceUi)A_CmsUI.get();
                    ui.showApp(appConfig);
                }
            }
        });
        CmsAppVisibilityStatus status = appConfig.getVisibility(cms);
        if (!status.isActive()) {
            button.setEnabled(false);
            button.setDescription(status.getHelpText());
        } else {
            String helpText = appConfig.getHelpText(locale);
            button.setDescription(helpText);
        }
        return button;
    }

    public static Button createAppIconButton(I_CmsWorkplaceAppConfiguration appConfig, Locale locale) {
        return CmsDefaultAppButtonProvider.createIconButton(appConfig.getName(locale), appConfig.getHelpText(locale), appConfig.getIcon(), appConfig.getButtonStyle());
    }

    public static Button createIconButton(String name, String description, Resource icon) {
        return CmsDefaultAppButtonProvider.createIconButton(name, description, icon, "o-color-transparent");
    }

    public static Button createIconButton(String name, String description, Resource icon, String buttonStyle) {
        Button button = new Button(name);
        button.setIcon(icon, name);
        button.setDescription(description);
        button.addStyleName("o-app-button");
        button.addStyleName("borderless");
        button.addStyleName("icon-align-top");
        button.addStyleName(buttonStyle);
        return button;
    }

    @Override
    public Component createAppButton(I_CmsWorkplaceAppConfiguration appConfig) {
        return CmsDefaultAppButtonProvider.createAppButton(A_CmsUI.getCmsObject(), appConfig, UI.getCurrent().getLocale());
    }
}

