/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.ui.apps.I_CmsAppSettings;
import org.opencms.ui.components.CmsResourceTableProperty;

public class CmsFileExplorerSettings
implements Serializable,
I_CmsAppSettings {
    private static final Log LOG = CmsLog.getLog(CmsFileExplorerSettings.class);
    private static final String COLLAPSED_COLUMNS_KEY = "collapsed_collumns";
    private static final long serialVersionUID = 1L;
    private static final String SORT_COLUMN_KEY = "sort_column";
    private static final String SORT_ORDER_KEY = "sort_order";
    private List<CmsResourceTableProperty> m_collapsedColumns;
    private boolean m_sortAscending = true;
    private CmsResourceTableProperty m_sortColumnId = CmsResourceTableProperty.PROPERTY_RESOURCE_NAME;

    public CmsFileExplorerSettings() {
        this.m_collapsedColumns = new ArrayList<CmsResourceTableProperty>();
        Collections.addAll(this.m_collapsedColumns, CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT, CmsResourceTableProperty.PROPERTY_PERMISSIONS, CmsResourceTableProperty.PROPERTY_USER_MODIFIED, CmsResourceTableProperty.PROPERTY_DATE_CREATED, CmsResourceTableProperty.PROPERTY_USER_CREATED, CmsResourceTableProperty.PROPERTY_STATE_NAME, CmsResourceTableProperty.PROPERTY_USER_LOCKED);
    }

    public List<CmsResourceTableProperty> getCollapsedColumns() {
        return this.m_collapsedColumns;
    }

    @Override
    public String getSettingsString() {
        JSONObject json = new JSONObject();
        try {
            json.put(SORT_ORDER_KEY, this.m_sortAscending);
            json.put(SORT_COLUMN_KEY, this.m_sortColumnId.getId());
            ArrayList collapsed = Lists.newArrayList();
            for (CmsResourceTableProperty column : this.m_collapsedColumns) {
                collapsed.add(column.getId());
            }
            json.put(COLLAPSED_COLUMNS_KEY, new JSONArray(collapsed));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    public CmsResourceTableProperty getSortColumnId() {
        return this.m_sortColumnId;
    }

    public boolean isSortAscending() {
        return this.m_sortAscending;
    }

    @Override
    public void restoreSettings(String storedSettings) {
        Map<String, CmsResourceTableProperty> columnMap = CmsResourceTableProperty.getDefaultColumnsByName();
        try {
            JSONObject json = new JSONObject(storedSettings);
            if (json.has(SORT_ORDER_KEY)) {
                this.m_sortAscending = json.getBoolean(SORT_ORDER_KEY);
            }
            if (json.has(SORT_COLUMN_KEY)) {
                this.m_sortColumnId = columnMap.get(json.getString(SORT_COLUMN_KEY));
            }
            if (json.has(COLLAPSED_COLUMNS_KEY)) {
                ArrayList<CmsResourceTableProperty> collapsed = new ArrayList<CmsResourceTableProperty>();
                JSONArray array = json.getJSONArray(COLLAPSED_COLUMNS_KEY);
                for (int i = 0; i < array.length(); ++i) {
                    collapsed.add(columnMap.get(array.getString(i)));
                }
                this.m_collapsedColumns = collapsed;
            }
        }
        catch (JSONException e) {
            LOG.error((Object)("Failed to restore file explorer settings from '" + storedSettings + "'"), (Throwable)e);
        }
    }

    public void setCollapsedColumns(List<CmsResourceTableProperty> collapsedColumns) {
        this.m_collapsedColumns = collapsedColumns;
    }

    public void setSortAscending(boolean sortAscending) {
        this.m_sortAscending = sortAscending;
    }

    public void setSortColumnId(CmsResourceTableProperty sortColumnId) {
        this.m_sortColumnId = sortColumnId;
    }
}

