/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Notification;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspTagEnableAde;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.A_CmsWorkplaceAppConfiguration;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsQuickLaunchLocationCache;
import org.opencms.ui.apps.I_CmsHasAppLaunchCommand;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.OpenCmsTheme;
import org.opencms.util.CmsStringUtil;

public class CmsPageEditorConfiguration
extends A_CmsWorkplaceAppConfiguration
implements I_CmsHasAppLaunchCommand {
    public static final String APP_ID = "pageeditor";
    private static final Log LOG = CmsLog.getLog(CmsPageEditorConfiguration.class);

    @Override
    public String getAppCategory() {
        return "Main";
    }

    @Override
    public I_CmsWorkplaceApp getAppInstance() {
        throw new IllegalStateException("The editor app should be launched through the app launch command only.");
    }

    @Override
    public Runnable getAppLaunchCommand() {
        return new Runnable(){

            @Override
            public void run() {
                CmsPageEditorConfiguration.this.openPageEditor();
            }
        };
    }

    @Override
    public String getButtonStyle() {
        return "o-color-transparent";
    }

    @Override
    public String getHelpText(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_PAGEEDITOR_HELP_0");
    }

    @Override
    public Resource getIcon() {
        return new ExternalResource(OpenCmsTheme.getImageLink("apps/editor.png"));
    }

    @Override
    public String getId() {
        return APP_ID;
    }

    @Override
    public String getName(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_PAGEEDITOR_TITLE_0");
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public CmsAppVisibilityStatus getVisibility(CmsObject cms) {
        boolean active = !cms.getRequestContext().getCurrentProject().isOnlineProject() && CmsStringUtil.isNotEmptyOrWhitespaceOnly(cms.getRequestContext().getSiteRoot());
        HttpServletRequest req = CmsVaadinUtils.getRequest();
        String message = null;
        if (active) {
            if (req != null) {
                boolean bl = active = this.getPath(cms, req.getSession()) != null;
                if (!active) {
                    message = CmsVaadinUtils.getMessageText("GUI_PAGE_EDITOR_PLEASE_SELECT_PAGE_0", new Object[0]);
                }
            }
        } else {
            message = CmsVaadinUtils.getMessageText("GUI_PAGE_EDITOR_NOT_AVAILABLE_0", new Object[0]);
        }
        return new CmsAppVisibilityStatus(true, active, message);
    }

    void openPageEditor() {
        CmsAppWorkplaceUi ui = CmsAppWorkplaceUi.get();
        if (ui.beforeViewChange(new ViewChangeListener.ViewChangeEvent(ui.getNavigator(), ui.getCurrentView(), null, APP_ID, null))) {
            CmsObject cms = A_CmsUI.getCmsObject();
            HttpServletRequest req = CmsVaadinUtils.getRequest();
            if (req == null) {
                throw new RuntimeException("Wrong usage, this can not be called from outside a VAADIN UI.");
            }
            CmsJspTagEnableAde.removeDirectEditFlagFromSession(req.getSession());
            String page = this.getPath(cms, req.getSession());
            if (page != null) {
                A_CmsUI.get().getPage().setLocation(OpenCms.getLinkManager().substituteLink(cms, page));
            } else {
                String message = CmsVaadinUtils.getMessageText("GUI_PAGE_EDITOR_NOT_AVAILABLE_0", new Object[0]);
                Notification.show((String)message, (Notification.Type)Notification.Type.WARNING_MESSAGE);
            }
        }
    }

    private String getPath(CmsObject cms, HttpSession session) {
        CmsQuickLaunchLocationCache locationCache = CmsQuickLaunchLocationCache.getLocationCache(session);
        String page = locationCache.getPageEditorLocation(cms.getRequestContext().getSiteRoot());
        if (page == null) {
            try {
                CmsResource mainDefaultFile = cms.readDefaultFile("/");
                if (mainDefaultFile != null) {
                    page = cms.getSitePath(mainDefaultFile);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return page;
    }
}

