/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.projects;

import com.vaadin.event.FieldEvents;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsFileExplorer;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.projects.CmsEditProjectForm;
import org.opencms.ui.apps.projects.CmsProjectHistoryTable;
import org.opencms.ui.apps.projects.CmsProjectsTable;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsFileTableDialogContext;
import org.opencms.ui.components.OpenCmsTheme;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsProjectManager
extends A_CmsWorkplaceApp {
    public static final String ICON_PROJECT_SMALL = "apps/project_fileicon.png";
    public static final String PATH_NAME_ADD = "add";
    public static final String PATH_NAME_EDIT = "edit";
    public static final String PATH_NAME_FILES = "files";
    public static final String PATH_NAME_HISTORY = "history";
    private static final String ICON_ADD = "apps/project_add.png";
    private static final String ICON_HISTORY = "apps/project_history.png";
    private static Log LOG = CmsLog.getLog(CmsProjectManager.class.getName());
    private TextField m_fileTableFilter;
    private TextField m_projectTableFilter;

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        CmsUUID projectId;
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_PROJECTS_MANAGER_TITLE_0", new Object[0]));
        } else if (state.equals(PATH_NAME_ADD)) {
            crumbs.put("project-management", CmsVaadinUtils.getMessageText("GUI_PROJECTS_MANAGER_TITLE_0", new Object[0]));
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_PROJECTS_ADD_0", new Object[0]));
        } else if (state.equals(PATH_NAME_HISTORY)) {
            crumbs.put("project-management", CmsVaadinUtils.getMessageText("GUI_PROJECTS_MANAGER_TITLE_0", new Object[0]));
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_PROJECTS_HISTORY_0", new Object[0]));
        } else if (state.startsWith(PATH_NAME_EDIT)) {
            CmsUUID projectId2 = this.getIdFromState(state);
            if (projectId2 != null) {
                crumbs.put("project-management", CmsVaadinUtils.getMessageText("GUI_PROJECTS_MANAGER_TITLE_0", new Object[0]));
                try {
                    crumbs.put("", CmsVaadinUtils.getMessageText("GUI_PROJECTS_EDIT_1", A_CmsUI.getCmsObject().readProject(projectId2).getName()));
                }
                catch (CmsException e) {
                    LOG.error((Object)"Error reading project for bread crumb.", (Throwable)e);
                }
            }
        } else if (state.startsWith(PATH_NAME_FILES) && (projectId = this.getIdFromState(state)) != null) {
            crumbs.put("project-management", CmsVaadinUtils.getMessageText("GUI_PROJECTS_MANAGER_TITLE_0", new Object[0]));
            try {
                crumbs.put("", CmsVaadinUtils.getMessageText("GUI_PROJECTS_FILES_1", A_CmsUI.getCmsObject().readProject(projectId).getName()));
            }
            catch (CmsException e) {
                LOG.error((Object)"Error reading project for bread crumb.", (Throwable)e);
            }
        }
        return crumbs;
    }

    @Override
    protected Component getComponentForState(String state) {
        CmsUUID projectId;
        if (this.m_fileTableFilter != null) {
            this.m_infoLayout.removeComponent((Component)this.m_fileTableFilter);
            this.m_fileTableFilter = null;
        }
        if (this.m_projectTableFilter != null) {
            this.m_infoLayout.removeComponent((Component)this.m_projectTableFilter);
            this.m_projectTableFilter = null;
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            this.m_rootLayout.setMainHeightFull(true);
            final CmsProjectsTable table = this.getProjectsTable();
            this.m_projectTableFilter = new TextField();
            this.m_projectTableFilter.setIcon((Resource)FontOpenCms.FILTER);
            this.m_projectTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
            this.m_projectTableFilter.addStyleName("inline-icon");
            this.m_projectTableFilter.setWidth("200px");
            this.m_projectTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
                private static final long serialVersionUID = 1L;

                public void textChange(FieldEvents.TextChangeEvent event) {
                    table.filterTable(event.getText());
                }
            });
            this.m_infoLayout.addComponent((Component)this.m_projectTableFilter);
            return table;
        }
        if (state.equals(PATH_NAME_ADD)) {
            this.m_rootLayout.setMainHeightFull(false);
            return this.getNewProjectForm();
        }
        if (state.equals(PATH_NAME_HISTORY)) {
            this.m_rootLayout.setMainHeightFull(true);
            return new CmsProjectHistoryTable();
        }
        if (state.startsWith(PATH_NAME_EDIT)) {
            CmsUUID projectId2 = this.getIdFromState(state);
            if (projectId2 != null) {
                this.m_rootLayout.setMainHeightFull(false);
                return new CmsEditProjectForm(this, projectId2);
            }
        } else if (state.startsWith(PATH_NAME_FILES) && (projectId = this.getIdFromState(state)) != null) {
            this.m_rootLayout.setMainHeightFull(true);
            final CmsFileTable fileTable = this.getProjectFiles(projectId);
            this.m_fileTableFilter = new TextField();
            this.m_fileTableFilter.setIcon((Resource)FontOpenCms.FILTER);
            this.m_fileTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
            this.m_fileTableFilter.addStyleName("inline-icon");
            this.m_fileTableFilter.setWidth("200px");
            this.m_fileTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
                private static final long serialVersionUID = 1L;

                public void textChange(FieldEvents.TextChangeEvent event) {
                    fileTable.filterTable(event.getText());
                }
            });
            this.m_infoLayout.addComponent((Component)this.m_fileTableFilter);
            return fileTable;
        }
        return null;
    }

    protected Component getNewProjectForm() {
        return new CmsEditProjectForm(this);
    }

    protected CmsFileTable getProjectFiles(CmsUUID projectId) {
        final CmsFileTable fileTable = new CmsFileTable(null);
        fileTable.applyWorkplaceAppSettings();
        fileTable.setContextProvider(new I_CmsContextProvider(){

            @Override
            public I_CmsDialogContext getDialogContext() {
                CmsFileTableDialogContext context = new CmsFileTableDialogContext("project-management", I_CmsDialogContext.ContextType.fileTable, fileTable, fileTable.getSelectedResources());
                context.setEditableProperties(CmsFileExplorer.INLINE_EDIT_PROPERTIES);
                return context;
            }
        });
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            List<CmsResource> childResources = cms.readProjectView(projectId, CmsResource.STATE_KEEP);
            fileTable.fillTable(cms, childResources);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(CmsVaadinUtils.getMessageText("ERR_PROJECTS_CAN_NOT_DISPLAY_FILES_0", new Object[0]), e);
        }
        return fileTable;
    }

    protected CmsProjectsTable getProjectsTable() {
        CmsProjectsTable table = new CmsProjectsTable(this);
        table.loadProjects();
        return table;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            ArrayList<A_CmsWorkplaceApp.NavEntry> subNav = new ArrayList<A_CmsWorkplaceApp.NavEntry>();
            subNav.add(new A_CmsWorkplaceApp.NavEntry(CmsVaadinUtils.getMessageText("GUI_PROJECTS_ADD_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_PROJECTS_ADD_DESCRIPTION_0", new Object[0]), (Resource)new ExternalResource(OpenCmsTheme.getImageLink(ICON_ADD)), PATH_NAME_ADD));
            subNav.add(new A_CmsWorkplaceApp.NavEntry(CmsVaadinUtils.getMessageText("GUI_PROJECTS_HISTORY_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_PROJECTS_HISTORY_DESCRIPTION_0", new Object[0]), (Resource)new ExternalResource(OpenCmsTheme.getImageLink(ICON_HISTORY)), PATH_NAME_HISTORY));
            return subNav;
        }
        return null;
    }

    private CmsUUID getIdFromState(String state) {
        CmsUUID result = null;
        String temp = A_CmsWorkplaceApp.getParamFromState(state, "projectId");
        if (CmsUUID.isValidUUID(temp)) {
            result = new CmsUUID(temp);
        }
        return result;
    }
}

