/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.search;

import com.vaadin.server.Resource;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceAppConfiguration;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.search.CmsSourceSearchApp;

public class CmsSourceSearchAppConfiguration
extends A_CmsWorkplaceAppConfiguration {
    public static final String APP_ID = "source-search";

    @Override
    public String getAppCategory() {
        return "Main";
    }

    @Override
    public I_CmsWorkplaceApp getAppInstance() {
        return new CmsSourceSearchApp();
    }

    @Override
    public String getButtonStyle() {
        return "o-color-orange";
    }

    @Override
    public String getHelpText(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_SOURCE_SEARCH_HELP_0");
    }

    @Override
    public Resource getIcon() {
        return FontOpenCms.SEARCH;
    }

    @Override
    public String getId() {
        return APP_ID;
    }

    @Override
    public String getName(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_SOURCE_SEARCH_TITLE_0");
    }

    @Override
    public int getOrder() {
        return 6;
    }

    @Override
    public CmsAppVisibilityStatus getVisibility(CmsObject cms) {
        CmsAppVisibilityStatus status = OpenCms.getRoleManager().hasRole(cms, CmsRole.ADMINISTRATOR) ? CmsAppVisibilityStatus.ACTIVE : CmsAppVisibilityStatus.INVISIBLE;
        return status;
    }
}

