/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.search;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.util.IndexedContainer;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.util.Collections;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndex;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.search.CmsSearchReplaceSettings;
import org.opencms.ui.apps.search.CmsSourceSearchApp;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSourceSearchForm
extends VerticalLayout {
    private static final long serialVersionUID = 1023130318064811880L;
    private CmsSourceSearchApp m_app;
    private ComboBox m_locale;
    private CheckBox m_replace;
    private TextField m_replacePattern;
    private ComboBox m_resourceType;
    private Button m_search;
    private ComboBox m_searchIndex;
    private TextField m_searchPattern;
    private CmsPathSelectField m_searchRoot;
    private ComboBox m_searchType;
    private TextField m_solrQuery;
    private ComboBox m_workProject;
    private TextField m_xPath;

    public CmsSourceSearchForm(CmsSourceSearchApp app) {
        this.m_app = app;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.initFields();
        this.m_replace.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsSourceSearchForm.this.updateReplace();
            }
        });
        this.m_searchType.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsSourceSearchForm.this.changedSearchType();
            }
        });
        this.m_search.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSourceSearchForm.this.search();
            }
        });
        this.updateReplace();
        this.changedSearchType();
    }

    public void initFormValues(CmsSearchReplaceSettings settings) {
        this.m_searchType.setValue((Object)settings.getType());
        if (!settings.getPaths().isEmpty()) {
            this.m_searchRoot.setValue(settings.getPaths().get(0));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(settings.getTypes())) {
            try {
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(settings.getTypes());
                this.m_resourceType.setValue((Object)type);
            }
            catch (CmsLoaderException cmsLoaderException) {
                // empty catch block
            }
        }
        this.m_searchPattern.setValue(settings.getSearchpattern());
        if (settings.getType().isContentValuesOnly()) {
            if (settings.getLocale() != null) {
                this.m_locale.setValue((Object)settings.getLocale());
            }
            this.m_xPath.setValue(settings.getXpath());
        }
        if (settings.getType().isSolrSearch()) {
            this.m_solrQuery.setValue(settings.getQuery());
            this.m_searchIndex.setValue((Object)settings.getSource());
        }
    }

    void changedSearchType() {
        SearchType type = (SearchType)((Object)this.m_searchType.getValue());
        this.m_searchIndex.setVisible(type.isSolrSearch());
        this.m_solrQuery.setVisible(type.isSolrSearch());
        this.updateReplace();
        this.m_xPath.setVisible(type.isContentValuesOnly());
        this.m_locale.setVisible(type.isContentValuesOnly());
        IndexedContainer types = (IndexedContainer)this.m_resourceType.getContainerDataSource();
        types.removeAllContainerFilters();
        types.addContainerFilter(type.isContentValuesOnly() ? CmsVaadinUtils.FILTER_XML_CONTENTS : CmsVaadinUtils.FILTER_NO_FOLDERS);
    }

    void search() {
        CmsSearchReplaceSettings settings = new CmsSearchReplaceSettings();
        settings.setType((SearchType)((Object)this.m_searchType.getValue()));
        settings.setPaths(Collections.singletonList(this.m_searchRoot.getValue()));
        I_CmsResourceType type = (I_CmsResourceType)this.m_resourceType.getValue();
        if (type != null) {
            settings.setTypes(type.getTypeName());
        }
        if (((Boolean)this.m_replace.getValue()).booleanValue()) {
            try {
                CmsProject workProject = A_CmsUI.getCmsObject().readProject((CmsUUID)this.m_workProject.getValue());
                settings.setProject(workProject.getName());
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            settings.setReplacepattern((String)this.m_replacePattern.getValue());
        }
        settings.setSearchpattern((String)this.m_searchPattern.getValue());
        if (settings.getType().isContentValuesOnly()) {
            if (this.m_locale.getValue() != null) {
                settings.setLocale(this.m_locale.getValue().toString());
            }
            settings.setXpath((String)this.m_xPath.getValue());
        }
        if (settings.getType().isSolrSearch()) {
            settings.setQuery((String)this.m_solrQuery.getValue());
            settings.setSource((String)this.m_searchIndex.getValue());
        }
        this.m_app.search(settings, true);
    }

    void updateReplace() {
        boolean replace = (Boolean)this.m_replace.getValue();
        this.m_replacePattern.setVisible(replace);
        this.m_workProject.setVisible(replace);
    }

    private void initFields() {
        CmsObject cms = A_CmsUI.getCmsObject();
        boolean online = cms.getRequestContext().getCurrentProject().isOnlineProject();
        this.m_searchType.setFilteringMode(FilteringMode.OFF);
        this.m_searchType.setNullSelectionAllowed(false);
        this.m_searchType.addItem((Object)SearchType.fullText);
        this.m_searchType.setItemCaption((Object)SearchType.fullText, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_SERACH_TYPE_FULLTEXT_0", new Object[0]));
        this.m_searchType.addItem((Object)SearchType.contentValues);
        this.m_searchType.setItemCaption((Object)SearchType.contentValues, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_SERACH_TYPE_XMLCONTENT_0", new Object[0]));
        if (OpenCms.getSearchManager().getSolrServerConfiguration().isEnabled()) {
            this.m_searchIndex.setFilteringMode(FilteringMode.OFF);
            this.m_searchIndex.setNullSelectionAllowed(false);
            Object selectIndex = null;
            for (CmsSearchIndex cmsSearchIndex : OpenCms.getSearchManager().getAllSolrIndexes()) {
                boolean offlineMode = "offline".equals(cmsSearchIndex.getRebuildMode());
                if ((online || !offlineMode) && (!online || offlineMode)) continue;
                this.m_searchIndex.addItem((Object)cmsSearchIndex.getName());
                if (selectIndex != null) continue;
                selectIndex = cmsSearchIndex.getName();
            }
            if (selectIndex != null) {
                this.m_searchIndex.setValue(selectIndex);
                this.m_searchType.addItem((Object)SearchType.solr);
                this.m_searchType.setItemCaption((Object)SearchType.solr, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_SERACH_TYPE_SOLR_0", new Object[0]));
                this.m_searchType.addItem((Object)SearchType.solrContentValues);
                this.m_searchType.setItemCaption((Object)SearchType.solrContentValues, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_SERACH_TYPE_SOLR_CONTENT_VALUES_0", new Object[0]));
            }
        }
        this.m_searchType.setValue((Object)SearchType.fullText);
        this.m_searchRoot.setValue("/");
        this.m_locale.setFilteringMode(FilteringMode.OFF);
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            this.m_locale.addItem((Object)locale);
        }
        this.m_resourceType.setNullSelectionAllowed(true);
        IndexedContainer resTypes = CmsVaadinUtils.getResourceTypesContainer();
        resTypes.addContainerFilter(CmsVaadinUtils.FILTER_NO_FOLDERS);
        this.m_resourceType.setContainerDataSource((Container)resTypes);
        this.m_resourceType.setItemCaptionPropertyId((Object)CmsVaadinUtils.PropertyId.caption);
        this.m_resourceType.setItemIconPropertyId((Object)CmsVaadinUtils.PropertyId.icon);
        this.m_workProject.setNullSelectionAllowed(false);
        IndexedContainer projects = CmsVaadinUtils.getProjectsContainer(A_CmsUI.getCmsObject(), "caption");
        projects.removeItem((Object)CmsProject.ONLINE_PROJECT_ID);
        this.m_workProject.setContainerDataSource((Container)projects);
        this.m_workProject.setItemCaptionPropertyId((Object)"caption");
        if (online) {
            this.m_replace.setEnabled(false);
        } else {
            this.m_workProject.setValue((Object)cms.getRequestContext().getCurrentProject().getUuid());
        }
    }

    public static enum SearchType {
        contentValues(false, true),
        fullText(false, false),
        solr(true, false),
        solrContentValues(true, true);

        private boolean m_contentValuesOnly;
        private boolean m_solrSearch;

        private SearchType(boolean solrSearch, boolean contentValuesOnly) {
            this.m_solrSearch = solrSearch;
            this.m_contentValuesOnly = contentValuesOnly;
        }

        public boolean isContentValuesOnly() {
            return this.m_contentValuesOnly;
        }

        public boolean isSolrSearch() {
            return this.m_solrSearch;
        }
    }
}

