/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Responsive;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.declarative.Design;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;

public class CmsAppViewLayout
extends CssLayout
implements I_CmsAppUIContext,
Page.BrowserWindowResizeListener {
    private static final long serialVersionUID = -290796815149968830L;
    private CssLayout m_appArea;
    private String m_appId;
    private CssLayout m_infoArea;
    private CmsToolBar m_toolbar;

    public CmsAppViewLayout(String appId) {
        this.m_appId = appId;
        Design.read((String)"CmsAppView.html", (Component)this);
        Responsive.makeResponsive((Component[])new Component[]{this});
        this.setWidth("100%");
        this.m_toolbar.init(this.m_appId);
    }

    @Override
    public Button addPublishButton(final I_CmsUpdateListener<String> updateListener) {
        Button publishButton = CmsToolBar.createButton((Resource)FontOpenCms.PUBLISH, CmsVaadinUtils.getMessageText("GUI_PUBLISH_BUTTON_TITLE_0", new Object[0]));
        if (CmsAppWorkplaceUi.isOnlineProject()) {
            publishButton.setEnabled(false);
            publishButton.setDescription(CmsVaadinUtils.getMessageText("GUI_TOOLBAR_NOT_AVAILABLE_ONLINE_0", new Object[0]));
        }
        publishButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsAppWorkplaceUi.get().disableGlobalShortcuts();
                CmsGwtDialogExtension extension = new CmsGwtDialogExtension(A_CmsUI.get(), updateListener);
                extension.openPublishDialog(A_CmsUI.getCmsObject().getRequestContext().getCurrentProject());
            }
        });
        this.addToolbarButton((Component)publishButton);
        return publishButton;
    }

    @Override
    public void addToolbarButton(Component button) {
        this.m_toolbar.addButtonLeft(button);
    }

    @Override
    public void addToolbarButtonRight(Component button) {
        this.m_toolbar.addButtonRight(button);
    }

    public void browserWindowResized(Page.BrowserWindowResizeEvent event) {
        this.m_toolbar.browserWindowResized(event);
    }

    @Override
    public void clearToolbarButtons() {
        this.m_toolbar.clearButtonsLeft();
    }

    public void closePopupViews() {
        this.m_toolbar.closePopupViews();
    }

    @Override
    public void enableDefaultToolbarButtons(boolean enabled) {
        this.m_toolbar.enableDefaultButtons(enabled);
    }

    @Override
    public String getAppId() {
        return this.m_appId;
    }

    @Override
    public void hideToolbar() {
        this.addStyleName("o-hidden-toolbar");
        this.m_toolbar.setVisible(false);
    }

    @Override
    public void removeToolbarButton(Component button) {
        this.m_toolbar.removeButton(button);
    }

    @Override
    public void setAppContent(Component appContent) {
        this.m_appArea.removeAllComponents();
        if (appContent != null) {
            this.m_appArea.addComponent(appContent);
        }
    }

    @Override
    public void setAppInfo(Component infoContent) {
        this.m_infoArea.removeAllComponents();
        this.m_infoArea.addComponent(infoContent);
    }

    @Override
    public void setAppTitle(String title) {
        CmsAppWorkplaceUi.setWindowTitle(title);
        this.m_toolbar.setAppTitle(title);
    }

    @Override
    public void setMenuDialogContext(I_CmsDialogContext context) {
        this.m_toolbar.setDialogContext(context);
    }

    @Override
    public void showInfoArea(boolean show) {
        this.m_infoArea.setVisible(show);
    }

    @Override
    public void showToolbar() {
        this.removeStyleName("o-hidden-toolbar");
        this.m_toolbar.setVisible(false);
    }

    @Override
    public void updateOnChange() {
        this.m_toolbar.updateAppIndicator();
    }

    @Override
    public void updateUserInfo() {
        this.m_toolbar.refreshUserInfoDropDown();
    }
}

