/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.google.common.collect.Lists;
import com.vaadin.event.Action;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.ui.declarative.DesignContext;
import java.util.List;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.Messages;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.extensions.CmsMaxHeightExtension;

public class CmsBasicDialog
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private Action.Handler m_actionHandler;
    private HorizontalLayout m_buttonPanelLeft;
    private HorizontalLayout m_buttonPanelRight;
    private Panel m_contentPanel;
    private Component m_infoComponent;
    private List<CmsResource> m_infoResources = Lists.newArrayList();
    private VerticalLayout m_mainPanel;
    private CmsMaxHeightExtension m_maxHeightExtension;
    private Page.BrowserWindowResizeListener m_windowResizeListener;

    public CmsBasicDialog() {
        this.addStyleName("o-dialog");
        this.setMargin(true);
        this.setSpacing(true);
        this.setWidth("100%");
        this.m_mainPanel = new VerticalLayout();
        this.m_mainPanel.addStyleName("o-dialog-content");
        this.m_mainPanel.setSpacing(true);
        this.m_mainPanel.setSizeFull();
        this.m_contentPanel = new Panel();
        this.m_contentPanel.setSizeFull();
        this.m_contentPanel.addStyleName("v-scrollable");
        this.m_mainPanel.addComponent((Component)this.m_contentPanel);
        this.m_mainPanel.setExpandRatio((Component)this.m_contentPanel, 3.0f);
        Panel panel = new Panel();
        panel.setContent((Component)this.m_mainPanel);
        panel.setSizeFull();
        this.addComponent((Component)panel);
        this.setExpandRatio((Component)panel, 1.0f);
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.setWidth("100%");
        buttons.addStyleName("o-dialog-button-bar");
        this.addComponent((Component)buttons);
        this.m_buttonPanelLeft = new HorizontalLayout();
        this.m_buttonPanelLeft.setSpacing(true);
        buttons.addComponent((Component)this.m_buttonPanelLeft);
        buttons.setComponentAlignment((Component)this.m_buttonPanelLeft, Alignment.MIDDLE_LEFT);
        this.m_buttonPanelLeft.setVisible(false);
        this.m_buttonPanelRight = new HorizontalLayout();
        this.m_buttonPanelRight.setSpacing(true);
        buttons.addComponent((Component)this.m_buttonPanelRight);
        buttons.setComponentAlignment((Component)this.m_buttonPanelRight, Alignment.MIDDLE_RIGHT);
        this.enableMaxHeight();
    }

    public static Window prepareWindow() {
        return CmsBasicDialog.prepareWindow(DialogWidth.narrow);
    }

    public static Window prepareWindow(DialogWidth width) {
        Window window = new Window();
        window.setModal(true);
        window.setClosable(true);
        int pageWidth = Page.getCurrent().getBrowserWindowWidth();
        if (width == DialogWidth.wide && pageWidth < 810 || width == DialogWidth.narrow && pageWidth < 610) {
            width = DialogWidth.max;
        }
        if (width == DialogWidth.max) {
            if (pageWidth >= 610 && pageWidth < 670) {
                width = DialogWidth.narrow;
            } else if (pageWidth >= 810 && pageWidth < 890) {
                width = DialogWidth.wide;
            }
        }
        switch (width) {
            case content: {
                break;
            }
            case wide: {
                window.setWidth("800px");
                break;
            }
            case max: {
                window.setWidth("90%");
                break;
            }
            default: {
                window.setWidth("600px");
            }
        }
        window.center();
        return window;
    }

    public void addButton(Component button) {
        this.addButton(button, true);
    }

    public void addButton(Component button, boolean right) {
        if (right) {
            this.m_buttonPanelRight.addComponent(button);
        } else {
            this.m_buttonPanelLeft.addComponent(button);
            this.m_buttonPanelLeft.setVisible(true);
        }
    }

    public void displayResourceInfo(List<CmsResource> resources) {
        this.m_infoResources = Lists.newArrayList(resources);
        if (this.m_infoComponent != null) {
            this.m_mainPanel.removeComponent(this.m_infoComponent);
            this.m_infoComponent = null;
        }
        if (resources != null && !resources.isEmpty()) {
            if (resources.size() == 1) {
                this.m_infoComponent = new CmsResourceInfo(resources.get(0));
                this.m_mainPanel.addComponent(this.m_infoComponent, 0);
            } else {
                this.m_infoComponent = this.createResourceListPanel(Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_RESOURCE_INFO_0"), resources);
                this.m_mainPanel.addComponent(this.m_infoComponent, 0);
                this.m_mainPanel.setExpandRatio(this.m_infoComponent, 1.0f);
                this.m_contentPanel.setSizeUndefined();
                this.m_contentPanel.setWidth("100%");
                this.m_mainPanel.setExpandRatio((Component)this.m_contentPanel, 0.0f);
            }
        }
    }

    public List<CmsResource> getInfoResources() {
        return this.m_infoResources;
    }

    public void initActionHandler(final Window window) {
        if (this.m_actionHandler != null) {
            window.addActionHandler(this.m_actionHandler);
            window.addCloseListener(new Window.CloseListener(){
                private static final long serialVersionUID = 1L;

                public void windowClose(Window.CloseEvent e) {
                    CmsBasicDialog.this.clearActionHandler(window);
                }
            });
        }
    }

    public void readDesign(Element design, DesignContext designContext) {
        for (Element child : design.children()) {
            boolean contentRead = false;
            boolean buttonsRead = false;
            boolean aboveRead = false;
            boolean belowRead = false;
            if ("content".equals(child.tagName()) && !contentRead) {
                Component content = designContext.readDesign(child.child(0));
                this.setContent(content);
                contentRead = true;
                continue;
            }
            if ("buttons".equals(child.tagName()) && !buttonsRead) {
                for (Element buttonElement : child.children()) {
                    Component button = designContext.readDesign(buttonElement);
                    Attributes attr = buttonElement.attributes();
                    this.addButton(button, !attr.hasKey(":left"));
                }
                buttonsRead = true;
                continue;
            }
            if ("above".equals(child.tagName()) && !aboveRead) {
                Component aboveContent = designContext.readDesign(child.child(0));
                this.setAbove(aboveContent);
                aboveRead = true;
                continue;
            }
            if (!"below".equals(child.tagName()) || belowRead) continue;
            Component belowContent = designContext.readDesign(child.child(0));
            this.setBelow(belowContent);
            belowRead = true;
        }
    }

    public void setAbove(Component aboveContent) {
        if (this.m_mainPanel.getComponentIndex((Component)this.m_contentPanel) == 0) {
            this.m_mainPanel.addComponent(aboveContent, 0);
        } else {
            this.m_mainPanel.replaceComponent(this.m_mainPanel.getComponent(0), aboveContent);
        }
    }

    public void setActionHandler(Action.Handler actionHandler) {
        this.m_actionHandler = actionHandler;
    }

    public void setBelow(Component belowContent) {
        int i = this.m_mainPanel.getComponentIndex((Component)this.m_mainPanel);
        Component oldBelow = this.m_mainPanel.getComponent(i + 1);
        if (oldBelow == null) {
            this.m_mainPanel.addComponent(belowContent);
        } else {
            this.m_mainPanel.replaceComponent(oldBelow, belowContent);
        }
    }

    public void setContent(Component content) {
        this.m_contentPanel.setContent(content);
        if (content instanceof Layout.MarginHandler) {
            ((Layout.MarginHandler)content).setMargin(true);
        }
    }

    protected Button createButtonCancel() {
        return new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CANCEL_0", new Object[0]));
    }

    protected Button createButtonOK() {
        return new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_OK_0", new Object[0]));
    }

    protected Panel createResourceListPanel(String caption, List<CmsResource> resources) {
        Panel result = new Panel(caption);
        result.addStyleName("v-scrollable");
        result.setSizeFull();
        VerticalLayout resourcePanel = new VerticalLayout();
        result.setContent((Component)resourcePanel);
        resourcePanel.addStyleName("o-reduced-margin");
        resourcePanel.addStyleName("o-reduced-spacing");
        resourcePanel.setSpacing(true);
        resourcePanel.setMargin(true);
        for (CmsResource resource : resources) {
            resourcePanel.addComponent((Component)new CmsResourceInfo(resource));
        }
        return result;
    }

    void clearActionHandler(Window window) {
        if (this.m_actionHandler != null) {
            window.removeActionHandler(this.m_actionHandler);
        }
    }

    private int calculateMaxHeight(int windowHeight) {
        return (int)(0.95 * (double)windowHeight - 40.0);
    }

    private void enableMaxHeight() {
        int maxHeight = this.calculateMaxHeight(A_CmsUI.get().getPage().getBrowserWindowHeight());
        this.m_maxHeightExtension = new CmsMaxHeightExtension((AbstractComponent)this, maxHeight);
        this.m_maxHeightExtension.addHeightChangeHandler(new Runnable(){

            @Override
            public void run() {
                Window wnd = CmsVaadinUtils.getWindow((Component)CmsBasicDialog.this);
                if (wnd != null) {
                    wnd.center();
                }
            }
        });
        this.addDetachListener(new ClientConnector.DetachListener(){
            private static final long serialVersionUID = 1L;

            public void detach(ClientConnector.DetachEvent event) {
                A_CmsUI.get().getPage().removeBrowserWindowResizeListener(CmsBasicDialog.this.m_windowResizeListener);
            }
        });
        this.m_windowResizeListener = new Page.BrowserWindowResizeListener(){
            private static final long serialVersionUID = 1L;

            public void browserWindowResized(Page.BrowserWindowResizeEvent event) {
                int newHeight = event.getHeight();
                CmsBasicDialog.this.m_maxHeightExtension.updateMaxHeight(CmsBasicDialog.this.calculateMaxHeight(newHeight));
            }
        };
        A_CmsUI.get().getPage().addBrowserWindowResizeListener(this.m_windowResizeListener);
    }

    public static enum DialogWidth {
        content,
        max,
        narrow,
        wide;

    }
}

