/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.google.common.collect.Maps;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.ui.Component;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.opencms.db.CmsResourceState;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsStringUtil;

public class CmsResourceTableProperty
implements Serializable {
    public static final CmsResourceTableProperty PROPERTY_CACHE = new CmsResourceTableProperty("PROPERTY_CACHE", "cache", String.class, null, "GUI_INPUT_CACHE_0", true, 2.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_COPYRIGHT = new CmsResourceTableProperty("PROPERTY_COPYRIGHT", "Copyright", String.class, null, "GUI_INPUT_COPYRIGHT_0", true, 2.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_DATE_CREATED = new CmsResourceTableProperty("PROPERTY_DATE_CREATED", Long.class, null, "GUI_INPUT_DATECREATED_0", true, 0.0f, 150, new DateConverter());
    public static final CmsResourceTableProperty PROPERTY_DATE_EXPIRED = new CmsResourceTableProperty("PROPERTY_DATE_EXPIRED", Long.class, null, "GUI_INPUT_DATEEXPIRED_0", true, 0.0f, 150, new DateConverter());
    public static final CmsResourceTableProperty PROPERTY_DATE_MODIFIED = new CmsResourceTableProperty("PROPERTY_DATE_MODIFIED", Long.class, null, "GUI_INPUT_DATELASTMODIFIED_0", true, 0.0f, 150, new DateConverter());
    public static final CmsResourceTableProperty PROPERTY_DATE_RELEASED = new CmsResourceTableProperty("PROPERTY_DATE_RELEASED", Long.class, null, "GUI_INPUT_DATERELEASED_0", true, 0.0f, 150, new DateConverter());
    public static final CmsResourceTableProperty PROPERTY_DISABLED = new CmsResourceTableProperty("PROPERTY_DISABLED", Boolean.class, Boolean.FALSE, "", true, 0.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_INSIDE_PROJECT = new CmsResourceTableProperty("PROPERTY_INSIDE_PROJECT", Boolean.class, Boolean.TRUE, null, true, 0.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_IS_FOLDER = new CmsResourceTableProperty("PROPERTY_IS_FOLDER", Boolean.class, null, null, true, 0.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_NAVIGATION_POSITION = new CmsResourceTableProperty("PROPERTY_NAVIGATION_POSITION", Float.class, null, null, true, 0.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_NAVIGATION_TEXT = new CmsResourceTableProperty("PROPERTY_NAVIGATION_TEXT", "NavText", String.class, null, "GUI_INPUT_NAVTEXT_0", true, 2.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_IN_NAVIGATION = new CmsResourceTableProperty("PROPERTY_IN_NAVIGATION", Boolean.class, Boolean.FALSE, null, true, 0.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_PERMISSIONS = new CmsResourceTableProperty("PROPERTY_PERMISSIONS", String.class, null, "GUI_INPUT_PERMISSIONS_0", true, 0.0f, 100);
    public static final CmsResourceTableProperty PROPERTY_PROJECT = new CmsResourceTableProperty("PROPERTY_PROJECT", Component.class, null, "GUI_LABEL_PROJECT_0", true, 0.0f, 32);
    public static final CmsResourceTableProperty PROPERTY_RELEASED_NOT_EXPIRED = new CmsResourceTableProperty("PROPERTY_RELEASED_NOT_EXPIRED", Boolean.class, Boolean.TRUE, null, true, 0.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_RESOURCE_NAME = new CmsResourceTableProperty("PROPERTY_RESOURCE_NAME", String.class, null, "GUI_INPUT_NAME_0", false, 2.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_RESOURCE_TYPE = new CmsResourceTableProperty("PROPERTY_RESOURCE_TYPE", String.class, null, "GUI_INPUT_TYPE_0", true, 0.0f, 180);
    public static final CmsResourceTableProperty PROPERTY_SITE_PATH = new CmsResourceTableProperty("PROPERTY_SITE_PATH", String.class, null, "GUI_INPUT_PATH_0", true, 0.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_SIZE = new CmsResourceTableProperty("PROPERTY_SIZE", Integer.class, null, "GUI_INPUT_SIZE_0", true, 0.0f, 100);
    public static final CmsResourceTableProperty PROPERTY_STATE = new CmsResourceTableProperty("PROPERTY_STATE", CmsResourceState.class, null, null, true, 0.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_STATE_NAME = new CmsResourceTableProperty("PROPERTY_STATE_NAME", String.class, null, "GUI_INPUT_STATE_0", true, 0.0f, 100);
    public static final CmsResourceTableProperty PROPERTY_TITLE = new CmsResourceTableProperty("PROPERTY_TITLE", "Title", String.class, null, "GUI_INPUT_TITLE_0", true, 3.0f, 0);
    public static final CmsResourceTableProperty PROPERTY_TREE_CAPTION = new CmsResourceTableProperty("PROPERTY_TREE_CAPTION", String.class, null, "", false, 0.0f, 40);
    public static final CmsResourceTableProperty PROPERTY_TYPE_ICON = new CmsResourceTableProperty("PROPERTY_TYPE_ICON", Component.class, null, "", false, 0.0f, 40);
    public static final CmsResourceTableProperty PROPERTY_USER_CREATED = new CmsResourceTableProperty("PROPERTY_USER_CREATED", String.class, null, "GUI_INPUT_USERCREATED_0", true, 0.0f, 150);
    public static final CmsResourceTableProperty PROPERTY_USER_LOCKED = new CmsResourceTableProperty("PROPERTY_USER_LOCKED", String.class, null, "GUI_INPUT_LOCKEDBY_0", true, 0.0f, 150);
    public static final CmsResourceTableProperty PROPERTY_USER_MODIFIED = new CmsResourceTableProperty("PROPERTY_USER_MODIFIED", String.class, null, "GUI_INPUT_USERLASTMODIFIED_0", true, 0.0f, 150);
    private static Map<String, CmsResourceTableProperty> m_columnsByName;
    private static final long serialVersionUID = -8006568789417647500L;
    private boolean m_collapsible;
    private Class<?> m_columnType;
    private int m_columnWidth;
    private Converter<String, ?> m_converter;
    private Object m_defaultValue;
    private String m_editPropertyId;
    private float m_expandRatio;
    private String m_headerKey;
    private String m_id;

    public CmsResourceTableProperty(String id, Class<?> columnType, Object defaultValue, String headerKey, boolean collapsible, float expandRation, int columnWidth) {
        this(id, columnType, defaultValue, headerKey, collapsible, expandRation, columnWidth, null);
    }

    public CmsResourceTableProperty(String id, Class<?> columnType, Object defaultValue, String headerKey, boolean collapsible, float expandRation, int columnWidth, Converter<String, ?> converter) {
        this.m_id = id;
        this.m_columnType = columnType;
        this.m_defaultValue = defaultValue;
        this.m_headerKey = headerKey;
        this.m_collapsible = collapsible;
        this.m_expandRatio = expandRation;
        this.m_columnWidth = columnWidth;
        this.m_converter = converter;
    }

    public CmsResourceTableProperty(String id, String editPropertyId, Class<?> columnType, Object defaultValue, String headerKey, boolean collapsible, float expandRation, int columnWidth) {
        this(id, columnType, defaultValue, headerKey, collapsible, expandRation, columnWidth, null);
        this.m_editPropertyId = editPropertyId;
    }

    public static List<CmsResourceTableProperty> defaultProperties() {
        return Arrays.asList(PROPERTY_PROJECT, PROPERTY_DATE_CREATED, PROPERTY_DATE_EXPIRED, PROPERTY_DATE_MODIFIED, PROPERTY_DATE_RELEASED, PROPERTY_IS_FOLDER, PROPERTY_NAVIGATION_TEXT, PROPERTY_COPYRIGHT, PROPERTY_CACHE, PROPERTY_PERMISSIONS, PROPERTY_RESOURCE_NAME, PROPERTY_RESOURCE_TYPE, PROPERTY_SIZE, PROPERTY_STATE, PROPERTY_STATE_NAME, PROPERTY_TITLE, PROPERTY_TYPE_ICON, PROPERTY_USER_CREATED, PROPERTY_USER_LOCKED, PROPERTY_USER_MODIFIED);
    }

    public static Map<String, CmsResourceTableProperty> getDefaultColumnsByName() {
        if (m_columnsByName == null) {
            m_columnsByName = Maps.newHashMap();
            for (CmsResourceTableProperty column : CmsResourceTableProperty.defaultProperties()) {
                m_columnsByName.put(column.getId(), column);
            }
        }
        return Collections.unmodifiableMap(m_columnsByName);
    }

    public boolean equals(Object other) {
        return other instanceof CmsResourceTableProperty && ((CmsResourceTableProperty)other).m_id.equals(this.m_id);
    }

    public Class<?> getColumnType() {
        return this.m_columnType;
    }

    public int getColumnWidth() {
        return this.m_columnWidth;
    }

    public Converter<String, ?> getConverter() {
        return this.m_converter;
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public String getEditPropertyId() {
        return this.m_editPropertyId;
    }

    public float getExpandRatio() {
        return this.m_expandRatio;
    }

    public String getHeaderKey() {
        return this.m_headerKey;
    }

    public String getId() {
        return this.m_id;
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public boolean isCollapsible() {
        return this.m_collapsible;
    }

    public boolean isEditProperty() {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_editPropertyId);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static class DateConverter
    implements Converter<String, Long> {
        private static final long serialVersionUID = -54133335743460680L;

        public Long convertToModel(String value, Class<? extends Long> targetType, Locale locale) throws Converter.ConversionException {
            throw new UnsupportedOperationException();
        }

        public String convertToPresentation(Long value, Class<? extends String> targetType, Locale locale) throws Converter.ConversionException {
            return value != null ? CmsVaadinUtils.getWpMessagesForCurrentLocale().getDateTime(value) : "-";
        }

        public Class<Long> getModelType() {
            return Long.class;
        }

        public Class<String> getPresentationType() {
            return String.class;
        }
    }
}

