/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import java.util.ArrayList;
import java.util.List;
import org.opencms.ui.shared.components.CmsUploadState;
import org.opencms.ui.shared.rpc.I_CmsUploadRpc;

public class CmsUploadButton
extends Button
implements I_CmsUploadRpc {
    private static final long serialVersionUID = -8591991683786743571L;
    private List<I_UploadListener> m_uploadListener;

    public CmsUploadButton(Resource icon, String targetFolderRootPath) {
        this(targetFolderRootPath);
        this.setIcon(icon);
    }

    public CmsUploadButton(String targetFolderRootPath) {
        this.registerRpc(this);
        this.m_uploadListener = new ArrayList<I_UploadListener>();
        this.getState().setTargetFolderRootPath(targetFolderRootPath);
    }

    public void addUploadListener(I_UploadListener listener) {
        this.m_uploadListener.add(listener);
    }

    @Override
    public void onUploadFinished(List<String> uploadedFiles) {
        for (I_UploadListener listener : this.m_uploadListener) {
            listener.onUploadFinished(uploadedFiles);
        }
    }

    public void removeUploadListener(I_UploadListener listener) {
        this.m_uploadListener.remove(listener);
    }

    public void setTargetFolder(String targetFolder) {
        this.getState().setTargetFolderRootPath(targetFolder);
    }

    protected CmsUploadState getState() {
        return (CmsUploadState)super.getState();
    }

    public static interface I_UploadListener {
        public void onUploadFinished(List<String> var1);
    }
}

