/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.extensions;

import com.google.common.collect.Lists;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.server.VaadinService;
import com.vaadin.ui.UI;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.ade.publish.CmsPublishService;
import org.opencms.ade.publish.shared.CmsPublishData;
import org.opencms.ade.publish.shared.rpc.I_CmsPublishService;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.CmsPrefetchSerializationPolicy;
import org.opencms.gwt.shared.CmsHistoryVersion;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.shared.components.I_CmsGwtDialogClientRpc;
import org.opencms.ui.shared.components.I_CmsGwtDialogServerRpc;
import org.opencms.util.CmsUUID;

public class CmsGwtDialogExtension
extends AbstractExtension
implements I_CmsGwtDialogServerRpc {
    private static final Log LOG = CmsLog.getLog(CmsGwtDialogExtension.class);
    private static final long serialVersionUID = 1L;
    private I_CmsUpdateListener<String> m_updateListener;

    public CmsGwtDialogExtension(UI ui, I_CmsUpdateListener<String> updateListener) {
        this.extend((AbstractClientConnector)ui);
        this.m_updateListener = updateListener;
        this.registerRpc(this, I_CmsGwtDialogServerRpc.class);
    }

    public void editPointer(CmsResource resource) {
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).editPointer("" + resource.getStructureId());
    }

    public void editProperties(CmsUUID structureId, boolean editName) {
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).editProperties("" + structureId, editName);
    }

    @Override
    public void onClose(boolean reinitUI) {
        this.remove();
        if (reinitUI) {
            A_CmsUI.get().reload();
        }
        if (this.m_updateListener != null) {
            this.m_updateListener.onUpdate(new ArrayList());
        }
    }

    @Override
    public void onClose(List<String> changedStructureIds, long delayMillis) {
        this.remove();
        if (delayMillis > 0L) {
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.m_updateListener != null) {
            this.m_updateListener.onUpdate(changedStructureIds);
        }
    }

    public void openCategories(CmsResource resource) {
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).openCategoriesDialog(resource.getStructureId().toString());
    }

    public void openGalleryDialog(CmsResource resource) {
        try {
            CmsObject cms = A_CmsUI.getCmsObject();
            JSONObject conf = new JSONObject();
            conf.put("gallerymode", I_CmsGalleryProviderConstants.GalleryMode.view.name());
            conf.put("gallerypath", cms.getSitePath(resource));
            conf.put("galleryprefix", "");
            conf.put("tabconfig", "selectAll");
            ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).openGalleryDialog(conf.toString());
        }
        catch (JSONException e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    public void openInfoDialog(CmsResource resource) {
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).openInfoDialog(resource.getStructureId().toString());
    }

    public void openLockReport(CmsResource resource) {
        String dialogTitle = CmsVaadinUtils.getMessageText("GUI_DIALOGTITLE_LOCKREPORT_0", new Object[0]);
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).openLockReport(dialogTitle, resource.getStructureId().toString());
    }

    public void openPublishDialog(CmsProject project) {
        CmsPublishData publishData = this.getPublishData(project);
        String data = this.getSerializedPublishData(publishData);
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).openPublishDialog(data);
    }

    public void openPublishDialog(List<CmsResource> resources) {
        String data = this.getSerializedPublishData(this.getPublishData(resources));
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).openPublishDialog(data);
    }

    public void openReplaceDialog(CmsUUID structureId) {
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).openReplaceDialog("" + structureId);
    }

    public void showAbout() {
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).showAbout();
    }

    public void showPreview(CmsUUID id, Integer version, CmsHistoryVersion.OfflineOnline offlineOnline) {
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).showPreview("" + id, version + ":" + (Object)((Object)offlineOnline));
    }

    public void showUserPreferences() {
        ((I_CmsGwtDialogClientRpc)this.getRpcProxy(I_CmsGwtDialogClientRpc.class)).showUserPreferences();
    }

    protected CmsPublishData getPublishData(CmsProject project) {
        CmsPublishService publishService = new CmsPublishService();
        CmsObject cms = A_CmsUI.getCmsObject();
        publishService.setCms(cms);
        publishService.setRequest((HttpServletRequest)VaadinService.getCurrentRequest());
        try {
            return publishService.getPublishData(cms, new HashMap<String, String>(), null, "" + project.getUuid(), new ArrayList<String>(), null, false);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    protected CmsPublishData getPublishData(List<CmsResource> directPublishResources) {
        CmsPublishService publishService = new CmsPublishService();
        CmsObject cms = A_CmsUI.getCmsObject();
        publishService.setCms(cms);
        ArrayList pathList = Lists.newArrayList();
        for (CmsResource resource : directPublishResources) {
            pathList.add(cms.getSitePath(resource));
        }
        publishService.setRequest((HttpServletRequest)VaadinService.getCurrentRequest());
        try {
            return publishService.getPublishData(cms, new HashMap<String, String>(), null, null, pathList, null, false);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    protected String getSerializedPublishData(CmsPublishData data) {
        try {
            String prefetchedData = RPC.encodeResponseForSuccess((Method)I_CmsPublishService.class.getMethod("getInitData", HashMap.class), (Object)data, (SerializationPolicy)CmsPrefetchSerializationPolicy.instance());
            return prefetchedData;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }
}

