/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.fileselect;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Window;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.fileselect.CmsResourceSelectDialog;
import org.opencms.ui.components.fileselect.I_CmsSelectionHandler;

public abstract class A_CmsFileSelectField<T>
extends CustomField<T> {
    private static final Log LOG = CmsLog.getLog(A_CmsFileSelectField.class);
    private static final long serialVersionUID = 1L;
    protected String m_fileSelectCaption;
    protected CmsResourceFilter m_filter;
    protected boolean m_startWithSitemapView;
    protected TextField m_textField = new TextField();

    public A_CmsFileSelectField() {
        this.m_textField.setWidth("100%");
        this.m_filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED;
    }

    public void setFileSelectCaption(String caption) {
        this.m_fileSelectCaption = caption;
    }

    public void setResourceFilter(CmsResourceFilter filter) {
        this.m_filter = filter;
    }

    public void setStartWithSitempaView(boolean startWithSitemapView) {
        this.m_startWithSitemapView = startWithSitemapView;
    }

    protected HorizontalLayout initContent() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setWidth("100%");
        layout.setSpacing(true);
        layout.addComponent((Component)this.m_textField);
        Button fileSelectButton = new Button("");
        fileSelectButton.addStyleName("o-button-icon");
        fileSelectButton.setIcon((Resource)FontOpenCms.GALLERY);
        layout.addComponent((Component)fileSelectButton);
        layout.setExpandRatio((Component)this.m_textField, 1.0f);
        fileSelectButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                A_CmsFileSelectField.this.openFileSelector();
            }
        });
        return layout;
    }

    protected void openFileSelector() {
        try {
            final Window window = CmsBasicDialog.prepareWindow();
            window.setCaption(this.m_fileSelectCaption != null ? this.m_fileSelectCaption : CmsVaadinUtils.getMessageText("GUI_FILE_SELECT_CAPTION_0", new Object[0]));
            A_CmsUI.get().addWindow(window);
            CmsResourceSelectDialog fileSelect = new CmsResourceSelectDialog(this.m_filter);
            fileSelect.showSitemapView(this.m_startWithSitemapView);
            Object value = this.getValue();
            if (value instanceof CmsResource) {
                fileSelect.showStartResource((CmsResource)value);
            } else if (value instanceof String) {
                fileSelect.openPath((String)value);
            }
            window.setContent((Component)fileSelect);
            fileSelect.addSelectionHandler(new I_CmsSelectionHandler<CmsResource>(){

                @Override
                public void onSelection(CmsResource selected) {
                    A_CmsFileSelectField.this.setResourceValue(selected);
                    window.close();
                }
            });
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    protected abstract void setResourceValue(CmsResource var1);
}

