/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.fileselect;

import com.vaadin.data.Property;
import org.opencms.file.CmsResource;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.components.fileselect.A_CmsFileSelectField;

public class CmsPathSelectField
extends A_CmsFileSelectField<String> {
    private static final long serialVersionUID = 1L;
    private boolean m_useRootPaths;
    private boolean m_settingInternalValue;

    public CmsPathSelectField() {
        this.m_textField.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                String value = (String)event.getProperty().getValue();
                if (!CmsPathSelectField.this.m_settingInternalValue) {
                    CmsPathSelectField.this.setInternalValue(value);
                    CmsPathSelectField.this.fireValueChange(false);
                }
            }
        });
    }

    public Class<? extends String> getType() {
        return String.class;
    }

    public String getValue() {
        return (String)this.m_textField.getValue();
    }

    public boolean isUseRootPaths() {
        return this.m_useRootPaths;
    }

    public void setUseRootPaths(boolean useRootPaths) {
        this.m_useRootPaths = useRootPaths;
    }

    public void setValue(String value) {
        this.setValue(false, value);
    }

    protected void setInternalValue(String newValue) {
        this.m_settingInternalValue = true;
        try {
            super.setInternalValue((Object)newValue);
            this.m_textField.setValue(newValue);
        }
        finally {
            this.m_settingInternalValue = false;
        }
    }

    @Override
    protected void setResourceValue(CmsResource resource) {
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(resource.getRootPath());
        if (!this.m_useRootPaths && site != null && A_CmsUI.getCmsObject().getRequestContext().getSiteRoot().equals(site.getSiteRoot())) {
            this.setValue(true, A_CmsUI.getCmsObject().getSitePath(resource));
        } else {
            this.setValue(true, resource.getRootPath());
        }
    }

    protected void setValue(boolean fireChange, String value) {
        this.m_textField.setValue(value);
        this.fireValueChange(false);
    }
}

