/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.fileselect;

import com.google.common.collect.Lists;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.fileselect.CmsResourceSelectDialogContents;
import org.opencms.ui.components.fileselect.CmsResourceTreeContainer;
import org.opencms.ui.components.fileselect.CmsResourceTreeTable;
import org.opencms.ui.components.fileselect.I_CmsSelectionHandler;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsResourceSelectDialog
extends CustomComponent {
    public static final String PROPERTY_SITE_CAPTION = "caption";
    private static final Log LOG = CmsLog.getLog(CmsResourceSelectDialog.class);
    private static final long serialVersionUID = 1L;
    protected CmsObject m_currentCms;
    protected CmsResourceFilter m_filter;
    protected CmsResource m_root;
    private CmsResourceTreeTable m_fileTree;
    private boolean m_isSitemapView = true;
    private String m_siteRoot;
    private CmsResourceTreeContainer m_treeData;

    public CmsResourceSelectDialog(CmsResourceFilter filter) throws CmsException {
        this.m_filter = filter;
        CmsObject cms = A_CmsUI.getCmsObject();
        this.setCompositionRoot((Component)new CmsResourceSelectDialogContents());
        this.getSiteSelector().setContainerDataSource((Container)CmsVaadinUtils.getAvailableSitesContainer(cms, PROPERTY_SITE_CAPTION));
        this.m_siteRoot = cms.getRequestContext().getSiteRoot();
        this.getSiteSelector().setValue((Object)this.m_siteRoot);
        this.getSiteSelector().setNullSelectionAllowed(false);
        this.getSiteSelector().setItemCaptionPropertyId((Object)PROPERTY_SITE_CAPTION);
        this.getSiteSelector().setFilteringMode(FilteringMode.CONTAINS);
        this.getSiteSelector().addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                String site = (String)event.getProperty().getValue();
                CmsResourceSelectDialog.this.onSiteChange(site);
            }
        });
        CmsResource root = cms.readResource("/");
        this.m_fileTree = this.createTree(cms, root);
        this.m_treeData = this.m_fileTree.getTreeContainer();
        this.updateRoot(cms, root);
        this.getContents().getTreeContainer().addComponent((Component)this.m_fileTree);
        this.m_fileTree.setSizeFull();
        this.updateView();
    }

    public void addSelectionHandler(I_CmsSelectionHandler<CmsResource> handler) {
        this.m_fileTree.addResourceSelectionHandler(handler);
    }

    public void openPath(String path) {
        if (!CmsStringUtil.isPrefixPath(this.m_root.getRootPath(), path)) {
            CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(path);
            if (site != null) {
                this.getSiteSelector().setValue((Object)site.getSiteRoot());
                path = this.m_currentCms.getRequestContext().removeSiteRoot(path);
            } else if (OpenCms.getSiteManager().startsWithShared(path)) {
                this.getSiteSelector().setValue((Object)OpenCms.getSiteManager().getSharedFolder());
            } else if (path.startsWith("/system/")) {
                this.getSiteSelector().setValue((Object)"");
            }
        }
        if (!"/".equals(path)) {
            ArrayList idsToOpen = Lists.newArrayList();
            try {
                CmsResource currentFolder = this.m_currentCms.readResource(CmsResource.getParentFolder(path));
                if (!this.m_root.getStructureId().equals(currentFolder.getStructureId())) {
                    idsToOpen.add(currentFolder.getStructureId());
                    CmsResource parentFolder = null;
                    do {
                        try {
                            parentFolder = this.m_currentCms.readParentFolder(currentFolder.getStructureId());
                            idsToOpen.add(parentFolder.getStructureId());
                            currentFolder = parentFolder;
                        }
                        catch (CmsException e) {
                            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                            break;
                        }
                    } while (!parentFolder.getStructureId().equals(this.m_root.getStructureId()));
                    Collections.reverse(idsToOpen);
                    for (CmsUUID id : idsToOpen) {
                        this.m_fileTree.expandItem(id);
                    }
                }
            }
            catch (CmsException e) {
                LOG.debug((Object)"Can not read parent folder of current path.", (Throwable)e);
            }
        }
    }

    public void showSitemapView(boolean showSitemapView) {
        if (this.m_isSitemapView != showSitemapView) {
            this.m_isSitemapView = showSitemapView;
            this.updateView();
        }
    }

    public void showStartResource(CmsResource startResource) {
        this.openPath(startResource.getRootPath());
    }

    protected CmsResourceTreeTable createTree(CmsObject cms, CmsResource root) {
        return new CmsResourceTreeTable(cms, root, this.m_filter);
    }

    protected CmsResourceSelectDialogContents getContents() {
        return (CmsResourceSelectDialogContents)this.getCompositionRoot();
    }

    protected CmsResourceTreeTable getFileTree() {
        return this.m_fileTree;
    }

    protected void onSiteChange(String site) {
        try {
            this.m_treeData.removeAllItems();
            CmsObject rootCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            rootCms.getRequestContext().setSiteRoot("");
            CmsResource siteRootResource = rootCms.readResource(site);
            this.m_treeData.initRoot(rootCms, siteRootResource);
            this.m_fileTree.expandItem(siteRootResource.getStructureId());
            this.m_siteRoot = site;
            this.updateRoot(rootCms, siteRootResource);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void updateRoot(CmsObject rootCms, CmsResource siteRootResource) {
        this.m_root = siteRootResource;
        this.m_currentCms = rootCms;
        this.updateView();
    }

    protected void updateView() {
        this.m_fileTree.showSitemapView(this.m_isSitemapView);
    }

    private ComboBox getSiteSelector() {
        return this.getContents().getSiteSelector();
    }

    class PathSelectionAdapter
    implements I_CmsSelectionHandler<CmsResource> {
        private I_CmsSelectionHandler<String> m_pathHandler;
        private boolean m_useSitePaths;

        public PathSelectionAdapter(I_CmsSelectionHandler<String> pathHandler, boolean useSitePaths) {
            this.m_pathHandler = pathHandler;
            this.m_useSitePaths = useSitePaths;
        }

        @Override
        public void onSelection(CmsResource selected) {
            String path = selected.getRootPath();
            if (this.m_useSitePaths) {
                try {
                    CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                    cms.getRequestContext().setSiteRoot(CmsResourceSelectDialog.this.m_siteRoot);
                    path = cms.getRequestContext().removeSiteRoot(path);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.m_pathHandler.onSelection(path);
        }
    }
}

