/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.OptionGroup;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.CmsVfsService;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsUndoDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsUndoDialog.class);
    private static final long serialVersionUID = 1L;
    protected I_CmsDialogContext m_context;
    private Button m_cancelButton;
    private OptionGroup m_modifySubresourcesField;
    private Button m_okButton;
    private Label m_infoText;
    private Label m_modifiedText;
    private CheckBox m_undoMoveField;

    public CmsUndoDialog(I_CmsDialogContext context) {
        this.m_context = context;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()), null);
        this.m_infoText.setValue(CmsVaadinUtils.getMessageText("GUI_UNDO_CONFIRMATION_0", new Object[0]));
        boolean hasFolders = false;
        boolean hasMoved = false;
        if (context.getResources().size() == 1) {
            CmsResource singleRes = context.getResources().get(0);
            CmsResourceUtil resUtil = new CmsResourceUtil(context.getCms(), singleRes);
            String fileName = CmsResource.getName(singleRes.getRootPath());
            String date = CmsVfsService.formatDateTime(context.getCms(), singleRes.getDateLastModified());
            String user = resUtil.getUserLastModified();
            String key = "GUI_UNDO_LASTMODIFIED_INFO_3";
            String message = CmsVaadinUtils.getMessageText(key, fileName, date, user);
            this.m_modifiedText.setVisible(true);
            this.m_modifiedText.setValue(message);
        }
        for (CmsResource resource : context.getResources()) {
            if (resource.isFolder()) {
                hasFolders = true;
                break;
            }
            try {
                CmsObject cms = OpenCms.initCmsObject(context.getCms());
                cms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                CmsResource onlineres = cms.readResource(resource.getStructureId());
                hasMoved |= !onlineres.getRootPath().equals(resource.getRootPath());
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        boolean multi = context.getResources().size() > 1;
        String undoMessage = this.getUndoMessage(multi, hasFolders);
        this.m_infoText.setValue(undoMessage);
        this.m_modifySubresourcesField.setVisible(hasFolders);
        this.m_modifySubresourcesField.addItem((Object)"false");
        this.m_modifySubresourcesField.setItemCaption((Object)"false", this.getNonRecursiveMessage(multi, hasFolders));
        this.m_modifySubresourcesField.addItem((Object)"true");
        this.m_modifySubresourcesField.setItemCaption((Object)"true", this.getRecursiveMessage(multi, hasFolders));
        this.m_modifySubresourcesField.setValue((Object)"false");
        this.m_undoMoveField.setVisible(hasFolders || hasMoved);
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUndoDialog.this.cancel();
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUndoDialog.this.undo();
            }
        });
        this.displayResourceInfo(this.m_context.getResources());
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsUndoDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsUndoDialog.this.undo();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undo() {
        try {
            boolean recursive = Boolean.parseBoolean(this.m_modifySubresourcesField.getValue().toString());
            boolean undoMove = (Boolean)this.m_undoMoveField.getValue();
            CmsObject cms = this.m_context.getCms();
            HashSet<CmsUUID> updateResources = new HashSet<CmsUUID>();
            for (CmsResource resource : this.m_context.getResources()) {
                updateResources.add(resource.getStructureId());
                if (undoMove) {
                    updateResources.add(cms.readParentFolder(resource.getStructureId()).getStructureId());
                }
                CmsLockActionRecord actionRecord = null;
                try {
                    actionRecord = CmsLockUtil.ensureLock(this.m_context.getCms(), resource);
                    CmsResource.CmsResourceUndoMode mode = CmsResource.CmsResourceUndoMode.getUndoMode(undoMove, recursive);
                    cms.undoChanges(cms.getSitePath(resource), mode);
                    if (!undoMove) continue;
                    updateResources.add(cms.readParentFolder(resource.getStructureId()).getStructureId());
                }
                finally {
                    if (actionRecord == null || actionRecord.getChange() != CmsLockActionRecord.LockChange.locked) continue;
                    try {
                        this.m_context.getCms().unlockResource(cms.readResource(resource.getStructureId()));
                    }
                    catch (CmsLockException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            this.m_context.finish(updateResources);
        }
        catch (Exception e) {
            this.m_context.error(e);
        }
    }

    void cancel() {
        this.m_context.finish(new ArrayList<CmsUUID>());
    }

    String getNonRecursiveMessage(boolean multi, boolean hasFolder) {
        return CmsVaadinUtils.getMessageText(this.key("GUI_UNDO_NONRECURSIVE_", multi, hasFolder), new Object[0]);
    }

    String getRecursiveMessage(boolean multi, boolean hasFolder) {
        return CmsVaadinUtils.getMessageText(this.key("GUI_UNDO_RECURSIVE_", multi, hasFolder), new Object[0]);
    }

    String getUndoMessage(boolean multi, boolean hasFolder) {
        return CmsVaadinUtils.getMessageText(this.key("GUI_UNDO_", multi, hasFolder), new Object[0]);
    }

    private String key(String prefix, boolean multi, boolean hasFolder) {
        return prefix + (multi ? "MULTI" : "SINGLE") + "_" + (hasFolder ? "FOLDER" : "FILE") + "_0";
    }
}

