/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.history.diff;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.shared.CmsHistoryResourceBean;
import org.opencms.gwt.shared.CmsHistoryVersion;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.dialogs.history.diff.CmsPropertyCompareBean;
import org.opencms.ui.dialogs.history.diff.CmsVersionMacroResolver;
import org.opencms.ui.dialogs.history.diff.I_CmsDiffProvider;
import org.opencms.ui.util.table.CmsBeanTableBuilder;
import org.opencms.workplace.comparison.CmsAttributeComparison;

public abstract class A_CmsAttributeDiff
implements I_CmsDiffProvider {
    private static final String COMPARE_TABLE_MARKER = "cms-compare-table-marker";

    public static List<CmsAttributeComparison> filterDifferent(List<CmsAttributeComparison> comps) {
        return Lists.newArrayList((Iterable)Collections2.filter(comps, (Predicate)new IsAttributeDifference()));
    }

    public static String getVersionString(CmsHistoryResourceBean bean) {
        if (bean.getVersion().getVersionNumber() != null) {
            return bean.getVersion().getVersionNumber().toString();
        }
        if (bean.getVersion().isOffline()) {
            return "0";
        }
        return "-1";
    }

    public static CmsResource readResource(CmsObject cms, CmsHistoryResourceBean bean) throws CmsException {
        CmsHistoryVersion versionBean = bean.getVersion();
        if (versionBean.getVersionNumber() != null) {
            return (CmsResource)((Object)cms.readResource(bean.getStructureId(), versionBean.getVersionNumber()));
        }
        if (versionBean.isOnline()) {
            CmsObject onlineCms = OpenCms.initCmsObject(cms);
            onlineCms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
            return onlineCms.readResource(bean.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
        }
        return cms.readResource(bean.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
    }

    @Override
    public Optional<Component> diff(CmsObject cms, CmsHistoryResourceBean v1, CmsHistoryResourceBean v2) throws CmsException {
        List<CmsAttributeComparison> attrCompare = this.getDifferences(cms, v1, v2);
        if (attrCompare.isEmpty()) {
            return Optional.absent();
        }
        ArrayList compareBeans = Lists.newArrayList();
        for (CmsAttributeComparison comp : attrCompare) {
            compareBeans.add(new CmsPropertyCompareBean(comp));
        }
        CmsBeanTableBuilder<CmsPropertyCompareBean> builder = CmsBeanTableBuilder.newInstance(CmsPropertyCompareBean.class, A_CmsUI.get().getDisplayType().toString());
        builder.setMacroResolver(new CmsVersionMacroResolver(v1, v2));
        Table table = builder.buildTable(compareBeans);
        table.setSortEnabled(false);
        table.setWidth("100%");
        table.setPageLength(Math.min(12, compareBeans.size()));
        table.setStyleName(COMPARE_TABLE_MARKER);
        VerticalLayout vl = new VerticalLayout();
        vl.setMargin(true);
        vl.addComponent((Component)table);
        Panel panel = new Panel(this.getCaption());
        panel.setContent((Component)vl);
        return Optional.fromNullable((Object)panel);
    }

    public abstract String getCaption();

    public abstract List<CmsAttributeComparison> getDifferences(CmsObject var1, CmsHistoryResourceBean var2, CmsHistoryResourceBean var3) throws CmsException;

    public static class IsAttributeDifference
    implements Predicate<CmsAttributeComparison> {
        public boolean apply(CmsAttributeComparison input) {
            return !Objects.equal((Object)input.getVersion1(), (Object)input.getVersion2());
        }
    }
}

