/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.history.diff;

import com.google.common.base.Optional;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Panel;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.gwt.shared.CmsHistoryResourceBean;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.dialogs.history.diff.A_CmsAttributeDiff;
import org.opencms.ui.dialogs.history.diff.I_CmsDiffProvider;
import org.opencms.util.CmsRequestUtil;
import org.opencms.workplace.comparison.CmsHistoryListUtil;

public class CmsImageDiff
implements I_CmsDiffProvider {
    @Override
    public Optional<Component> diff(CmsObject cms, CmsHistoryResourceBean v1, CmsHistoryResourceBean v2) throws CmsException {
        CmsResource r1 = A_CmsAttributeDiff.readResource(cms, v1);
        if (OpenCms.getResourceManager().matchResourceType(CmsResourceTypeImage.getStaticTypeName(), r1.getTypeId())) {
            HorizontalLayout hl = new HorizontalLayout();
            hl.setSpacing(true);
            String v1Param = v1.getVersion().getVersionNumber() != null ? "" + v1.getVersion().getVersionNumber() : "2147483647";
            String v2Param = v2.getVersion().getVersionNumber() != null ? "" + v2.getVersion().getVersionNumber() : "2147483647";
            String link1 = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, CmsHistoryListUtil.getHistoryLink(cms, v1.getStructureId(), v1Param));
            String link2 = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, CmsHistoryListUtil.getHistoryLink(cms, v2.getStructureId(), v2Param));
            int scaleWidth = 400;
            int scaleHeight = 2 * scaleWidth / 3;
            String scaleParams = "w:" + scaleWidth + ",h:" + scaleHeight + ",t:1";
            link1 = CmsRequestUtil.appendParameter(link1, "__scale", scaleParams);
            link2 = CmsRequestUtil.appendParameter(link2, "__scale", scaleParams);
            Image img1 = new Image("", (Resource)new ExternalResource(link1));
            Image img2 = new Image("", (Resource)new ExternalResource(link2));
            for (Image img : new Image[]{img1, img2}) {
                img.setWidth("" + scaleWidth + "px");
            }
            img1.setCaption("V1");
            img2.setCaption("V2");
            hl.addComponent((Component)img1);
            hl.addComponent((Component)img2);
            Panel result = new Panel("Image comparison");
            hl.setMargin(true);
            result.setContent((Component)hl);
            return Optional.fromNullable((Object)result);
        }
        return Optional.absent();
    }
}

