/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.history.diff;

import com.vaadin.ui.Button;
import java.util.Date;
import org.opencms.file.CmsObject;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.util.table.Column;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.comparison.CmsElementComparison;
import org.opencms.workplace.comparison.CmsXmlContentElementComparison;

public class CmsValueCompareBean {
    private CmsObject m_cms;
    private CmsElementComparison m_elemComp;
    private Button m_getChangeTypeButton;

    public CmsValueCompareBean(CmsObject cms, CmsElementComparison elemComp) {
        this.m_cms = cms;
        this.m_elemComp = elemComp;
        String changeType = this.m_elemComp.getStatus();
        String key = null;
        String style = null;
        if ("added".equals(changeType)) {
            key = "GUI_COMPARE_ADDED_0";
            style = "diffTypeAdded";
        } else if ("removed".equals(changeType)) {
            key = "GUI_COMPARE_REMOVED_0";
            style = "diffTypeDeleted";
        } else if ("changed".equals(changeType)) {
            key = "GUI_COMPARE_CHANGED_0";
            style = "diffTypeChanged";
        } else {
            key = "GUI_COMPARE_UNCHANGED_0";
            style = "diffTypeUnchanged";
        }
        Button result = new Button();
        result.setCaption(CmsVaadinUtils.getMessageText(key, new Object[0]));
        result.addStyleName("link");
        result.addStyleName(style);
        this.m_getChangeTypeButton = result;
    }

    public static String formatContentValueForDiffTable(CmsObject cms, CmsElementComparison comparison, String origValue) {
        String result = CmsStringUtil.substitute(CmsStringUtil.trimToSize(origValue, 60), "\n", "");
        if (comparison instanceof CmsXmlContentElementComparison && ((CmsXmlContentElementComparison)comparison).getType().equals("OpenCmsDateTime") && CmsStringUtil.isNotEmpty(result)) {
            result = CmsDateUtil.getDateTime(new Date(Long.parseLong(result)), 3, cms.getRequestContext().getLocale());
        }
        return result;
    }

    @Column(header="GUI_HISTORY_DIALOG_COL_CHANGETYPE_0", order=10)
    public Button getChangeType() {
        return this.m_getChangeTypeButton;
    }

    @Column(header="GUI_HISTORY_DIALOG_COL_LOCALE_0", order=20)
    public String getLocale() {
        return this.m_elemComp.getLocale().toString();
    }

    @Column(header="V1 (%(v1))", order=40)
    public String getV1() {
        return CmsValueCompareBean.formatContentValueForDiffTable(this.m_cms, this.m_elemComp, this.m_elemComp.getVersion1());
    }

    @Column(header="V2 (%(v2))", order=50)
    public String getV2() {
        return CmsValueCompareBean.formatContentValueForDiffTable(this.m_cms, this.m_elemComp, this.m_elemComp.getVersion2());
    }

    @Column(header="GUI_HISTORY_DIALOG_COL_XPATH_0", order=30)
    public String getXPath() {
        return this.m_elemComp.getName();
    }
}

