/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.history.diff;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.shared.CmsHistoryResourceBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.dialogs.history.CmsHistoryDialog;
import org.opencms.ui.dialogs.history.diff.A_CmsAttributeDiff;
import org.opencms.ui.dialogs.history.diff.CmsTextDiffPanel;
import org.opencms.ui.dialogs.history.diff.CmsValueCompareBean;
import org.opencms.ui.dialogs.history.diff.CmsVersionMacroResolver;
import org.opencms.ui.dialogs.history.diff.I_CmsDiffProvider;
import org.opencms.ui.util.table.CmsBeanTableBuilder;
import org.opencms.util.CmsMacroResolver;
import org.opencms.workplace.comparison.CmsElementComparison;
import org.opencms.workplace.comparison.CmsXmlDocumentComparison;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsValueDiff
implements I_CmsDiffProvider {
    private static final Log LOG = CmsLog.getLog(CmsValueDiff.class);

    @Override
    public Optional<Component> diff(final CmsObject cms, CmsHistoryResourceBean v1, CmsHistoryResourceBean v2) throws CmsException {
        CmsResource resource1 = A_CmsAttributeDiff.readResource(cms, v1);
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource1);
        CmsVersionMacroResolver resolver = new CmsVersionMacroResolver(v1, v2);
        if (type instanceof CmsResourceTypeXmlContent || type instanceof CmsResourceTypeXmlPage) {
            CmsResource resource2 = A_CmsAttributeDiff.readResource(cms, v2);
            final Panel panel = new Panel(CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_CONTENT_VALUE_TABLE_CAPTION_0", new Object[0]));
            final CmsFile file1 = cms.readFile(resource1);
            final CmsFile file2 = cms.readFile(resource2);
            VerticalLayout vl = new VerticalLayout();
            vl.setMargin(true);
            vl.setSpacing(true);
            Table table = this.buildValueComparisonTable(cms, (Component)panel, file1, file2, resolver);
            if (table.getContainerDataSource().size() == 0) {
                return Optional.absent();
            }
            Button fileTextCompareButton = new Button(CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_COMPARE_WHOLE_FILE_0", new Object[0]));
            vl.addComponent((Component)fileTextCompareButton);
            vl.setComponentAlignment((Component)fileTextCompareButton, Alignment.MIDDLE_RIGHT);
            fileTextCompareButton.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    Component diffView = CmsValueDiff.this.buildWholeFileDiffView(cms, file1, file2);
                    CmsHistoryDialog.openChildDialog((Component)panel, diffView, CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_COMPARE_WHOLE_FILE_0", new Object[0]));
                }
            });
            vl.addComponent((Component)table);
            panel.setContent((Component)vl);
            Panel result = panel;
            return Optional.fromNullable((Object)result);
        }
        return Optional.absent();
    }

    private Table buildValueComparisonTable(CmsObject cms, final Component parent, CmsFile file1, CmsFile file2, CmsMacroResolver macroResolver) throws CmsException {
        CmsXmlDocumentComparison comp = new CmsXmlDocumentComparison(cms, file1, file2);
        CmsBeanTableBuilder<CmsValueCompareBean> builder = CmsBeanTableBuilder.newInstance(CmsValueCompareBean.class, A_CmsUI.get().getDisplayType().toString());
        builder.setMacroResolver(macroResolver);
        ArrayList rows = Lists.newArrayList();
        for (CmsElementComparison entry : comp.getElements()) {
            String text2;
            final String text1 = entry.getVersion1();
            if (Objects.equal((Object)text1, (Object)(text2 = entry.getVersion2()))) continue;
            final CmsValueCompareBean row = new CmsValueCompareBean(cms, entry);
            row.getChangeType().addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    CmsTextDiffPanel diffPanel = new CmsTextDiffPanel(text1, text2, true, true);
                    diffPanel.setSizeFull();
                    CmsHistoryDialog.openChildDialog(parent, (Component)diffPanel, CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_COMPARE_VALUE_1", row.getXPath()));
                }
            });
            rows.add(row);
        }
        Table table = builder.buildTable(rows);
        table.setSortEnabled(false);
        table.setWidth("100%");
        table.setPageLength(Math.min(rows.size(), 12));
        return table;
    }

    private Component buildWholeFileDiffView(CmsObject cms, CmsFile file1, CmsFile file2) {
        String encoding = "UTF-8";
        try {
            CmsXmlContent content1 = CmsXmlContentFactory.unmarshal(cms, file1);
            encoding = content1.getEncoding();
        }
        catch (CmsException e) {
            String rootPath = file1.getRootPath();
            LOG.error((Object)("Could not unmarshal file " + rootPath + " for determining encoding: " + e.getLocalizedMessage()), (Throwable)e);
        }
        String text1 = this.decode(file1.getContents(), encoding);
        String text2 = this.decode(file2.getContents(), encoding);
        CmsTextDiffPanel diffPanel = new CmsTextDiffPanel(text1, text2, false, true);
        return diffPanel;
    }

    private String decode(byte[] data, String encoding) {
        try {
            return new String(data, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return new String(data);
        }
    }
}

