/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.permissions;

import com.vaadin.ui.Accordion;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.dialogs.permissions.CmsPermissionView;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelect;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsPermissionDialog
extends CmsBasicDialog
implements CmsPermissionView.PermissionChangeHandler,
CmsPrincipalSelect.PrincipalSelectHandler {
    protected static final String[] PRINCIPAL_TYPES = new String[]{"GROUP", "USER", "ROLE", "ALL_OTHERS", "OVERWRITE_ALL"};
    protected static final int[] PRINCIPAL_TYPES_INT = new int[]{32, 16, 512, 128, 256};
    private static final Log LOG = CmsLog.getLog(CmsPermissionDialog.class);
    private static final long serialVersionUID = 2397141190651779325L;
    private Accordion m_accordion;
    private Button m_closeButton;
    private CmsObject m_cms;
    private I_CmsDialogContext m_context;
    private boolean m_editable = true;
    private VerticalLayout m_inheritedPermissions;
    private CmsLockActionRecord m_lockActionRecord;
    private VerticalLayout m_main;
    private CmsPrincipalSelect m_principalSelect;
    private CmsResource m_resource;
    private VerticalLayout m_resourcePermissions;
    private VerticalLayout m_setPermissionTab;
    private VerticalLayout m_userPermissions;

    public CmsPermissionDialog(I_CmsDialogContext context) {
        this.m_context = context;
        this.m_cms = context.getCms();
        this.m_editable = CmsStandardVisibilityCheck.PERMISSIONS.getVisibility(context).isActive();
        this.m_resource = context.getResources().get(0);
        boolean editRoles = CmsWorkplace.canEditPermissionsForRoles(this.m_cms, this.m_resource.getRootPath());
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_main.setHeightUndefined();
        if (this.m_editable) {
            this.m_principalSelect.setMargin(true);
            this.m_principalSelect.setSelectHandler(this);
            this.m_principalSelect.setRoleSelectionAllowed(editRoles);
        } else {
            this.m_principalSelect.setVisible(false);
        }
        this.displayResourceInfo(Collections.singletonList(this.m_resource));
        this.displayUserPermissions(this.m_cms.getRequestContext().getCurrentUser());
        this.displayInheritedPermissions();
        this.displayResourcePermissions();
        this.m_closeButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPermissionDialog.this.close();
            }
        });
        this.m_accordion.addSelectedTabChangeListener(new TabSheet.SelectedTabChangeListener(){
            private static final long serialVersionUID = 1L;

            public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
                CmsPermissionDialog.this.onViewChange();
            }
        });
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsPermissionDialog.this.close();
            }

            @Override
            protected void ok() {
            }
        });
        this.m_accordion.setSelectedTab((Component)this.m_setPermissionTab);
        this.m_principalSelect.setPrincipalType("GROUP");
    }

    @Override
    public void deletePermissionSet(String principalType, String principalName) {
        try {
            this.ensureLock();
            this.m_cms.rmacc(this.m_cms.getSitePath(this.m_resource), principalType, principalName);
            this.refreshOwnEntries();
        }
        catch (CmsException e) {
            this.m_context.error(e);
        }
    }

    @Override
    public void onPrincipalSelect(String principalType, String principalName) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(principalName)) {
            String permissionString = "";
            if (this.m_resource.isFolder()) {
                permissionString = "+i";
            }
            try {
                this.ensureLock();
                if (principalName.equals(CmsVaadinUtils.getMessageText("GUI_LABEL_ALLOTHERS_0", new Object[0]))) {
                    this.m_cms.chacc(this.m_cms.getSitePath(this.m_resource), principalType, "ALL_OTHERS", permissionString);
                } else if (principalName.equals(CmsVaadinUtils.getMessageText("GUI_LABEL_OVERWRITEALL_0", new Object[0]))) {
                    this.m_cms.chacc(this.m_cms.getSitePath(this.m_resource), principalType, "OVERWRITE_ALL", permissionString);
                } else {
                    CmsRole role2;
                    if (principalType.equalsIgnoreCase("ROLE") && (role2 = CmsRole.valueOfRoleName(principalName)) == null) {
                        for (CmsRole role2 : CmsRole.getSystemRoles()) {
                            if (!role2.getName(this.getLocale()).equalsIgnoreCase(principalName)) continue;
                            principalName = role2.getRoleName();
                            break;
                        }
                    }
                    this.m_cms.chacc(this.m_cms.getSitePath(this.m_resource), principalType, principalName, permissionString);
                }
                this.refreshOwnEntries();
                this.onViewChange();
            }
            catch (CmsException e) {
                this.m_context.error(e);
            }
        }
    }

    @Override
    public void onViewChange() {
        this.m_context.onViewChange();
    }

    @Override
    public void setPermissions(String principalType, String principalName, int allowed, int denied, int flags) {
        try {
            this.ensureLock();
            this.m_cms.chacc(this.m_cms.getSitePath(this.m_resource), principalType, principalName, allowed, denied, flags);
        }
        catch (CmsException e) {
            this.m_context.error(e);
        }
    }

    protected String getConnectedResource(CmsAccessControlEntry entry, Map<CmsUUID, String> parents) {
        CmsUUID resId = entry.getResource();
        String resName = parents.get(resId);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(resName)) {
            return resName;
        }
        return resId.toString();
    }

    void close() {
        try {
            this.clearLock();
            this.m_context.finish(Collections.singletonList(this.m_resource.getStructureId()));
        }
        catch (CmsException e) {
            this.m_context.error(e);
        }
    }

    void displayInheritedPermissions() {
        ArrayList<CmsAccessControlEntry> arrayList;
        HashMap<CmsUUID, String> parents;
        block7: {
            List<Object> parentResources;
            String path;
            block6: {
                parents = new HashMap<CmsUUID, String>();
                String sitePath = this.m_cms.getSitePath(this.m_resource);
                path = CmsResource.getParentFolder(sitePath);
                parentResources = new ArrayList();
                try {
                    parentResources = this.m_cms.readPath(path, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block6;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            for (CmsResource cmsResource : parentResources) {
                parents.put(cmsResource.getResourceId(), cmsResource.getRootPath());
            }
            arrayList = new ArrayList<CmsAccessControlEntry>();
            try {
                for (CmsAccessControlEntry curEntry : this.m_cms.getAccessControlEntries(path, true)) {
                    arrayList.add(curEntry);
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block7;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        this.buildInheritedList(arrayList, parents);
    }

    void displayResourcePermissions() {
        this.refreshOwnEntries();
    }

    void displayUserPermissions(CmsUser user) {
        CmsPermissionView view = this.buildPermissionEntryForm(user.getId(), this.buildPermissionsForCurrentUser(), false, false);
        view.hideDeniedColumn();
        this.m_userPermissions.addComponent((Component)view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildInheritedList(ArrayList<CmsAccessControlEntry> entries, Map<CmsUUID, String> parents) {
        String view = "long";
        if ("long".equals(view)) {
            for (CmsAccessControlEntry curEntry : entries) {
                CmsPermissionView permissionView = this.buildPermissionEntryForm(curEntry, false, true, this.getConnectedResource(curEntry, parents));
                if (permissionView == null) continue;
                this.m_inheritedPermissions.addComponent((Component)permissionView);
            }
            return;
        } else {
            try {
                CmsAccessControlList acList = this.m_cms.getAccessControlList(CmsResource.getParentFolder(this.m_cms.getSitePath(this.m_resource)), false);
                for (CmsUUID principalId : acList.getPrincipals()) {
                    CmsPermissionSetCustom permissions;
                    CmsPermissionView permissionView;
                    if (principalId.equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID) || (permissionView = this.buildPermissionEntryForm(principalId, permissions = acList.getPermissions(principalId), false, true)) == null) continue;
                    this.m_inheritedPermissions.addComponent((Component)permissionView);
                }
                return;
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) return;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
    }

    private CmsPermissionView buildPermissionEntryForm(CmsAccessControlEntry entry, boolean editable, boolean extendedView, String inheritRes) {
        return new CmsPermissionView(entry, editable, this.m_resource.isFolder(), inheritRes, this);
    }

    private CmsPermissionView buildPermissionEntryForm(CmsUUID id, CmsPermissionSet curSet, boolean editable, boolean extendedView) {
        String fileName = this.m_cms.getSitePath(this.m_resource);
        int flags = 0;
        try {
            I_CmsPrincipal p;
            try {
                p = CmsPrincipal.readPrincipalIncludingHistory(this.m_cms, id);
            }
            catch (CmsException e) {
                p = null;
            }
            if (p != null && p.isGroup()) {
                flags = 32;
            } else if (p != null && p.isUser()) {
                flags = 16;
            } else if (p == null && id.equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID)) {
                flags = 128;
            } else if (p == null && id.equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID)) {
                flags = 256;
            } else {
                CmsRole role = CmsRole.valueOfId(id);
                if (role != null) {
                    flags = 512;
                }
            }
            CmsResource res = this.m_cms.readResource(fileName, CmsResourceFilter.ALL);
            CmsAccessControlEntry entry = new CmsAccessControlEntry(res.getResourceId(), id, curSet, flags);
            return this.buildPermissionEntryForm(entry, editable, extendedView, null);
        }
        catch (CmsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e.getLocalizedMessage());
            }
            return null;
        }
    }

    private CmsPermissionSet buildPermissionsForCurrentUser() {
        CmsResourceUtil resUtil = new CmsResourceUtil(this.m_cms, this.m_resource);
        return resUtil.getPermissionSet();
    }

    private void clearLock() throws CmsException {
        if (this.m_lockActionRecord != null && this.m_lockActionRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
            CmsResource updatedRes = this.m_cms.readResource(this.m_resource.getStructureId(), CmsResourceFilter.ALL);
            try {
                this.m_cms.unlockResource(updatedRes);
            }
            catch (CmsLockException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.m_lockActionRecord = null;
        }
    }

    private void ensureLock() throws CmsException {
        if (this.m_lockActionRecord == null) {
            this.m_lockActionRecord = CmsLockUtil.ensureLock(this.m_cms, this.m_resource);
        }
    }

    private void refreshOwnEntries() {
        Iterator i;
        boolean hasEntries;
        ArrayList<CmsAccessControlEntry> ownEntries;
        block5: {
            this.m_resourcePermissions.removeAllComponents();
            String sitePath = this.m_cms.getSitePath(this.m_resource);
            ownEntries = new ArrayList<CmsAccessControlEntry>();
            try {
                for (CmsAccessControlEntry curEntry : this.m_cms.getAccessControlEntries(sitePath, false)) {
                    if (curEntry.isInherited()) continue;
                    ownEntries.add(curEntry);
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block5;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        if (hasEntries = (i = ownEntries.iterator()).hasNext()) {
            while (i.hasNext()) {
                CmsAccessControlEntry curEntry = (CmsAccessControlEntry)i.next();
                CmsPermissionView permissionView = this.buildPermissionEntryForm(curEntry, this.m_editable, false, null);
                if (permissionView == null) continue;
                this.m_resourcePermissions.addComponent((Component)permissionView);
            }
        }
    }
}

