/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.permissions;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.util.IndexedContainer;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.DefaultFieldFactory;
import com.vaadin.ui.Field;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.file.history.CmsHistoryPrincipal;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.dialogs.permissions.CmsPermissionDialog;
import org.opencms.workplace.commons.Messages;

public class CmsPermissionView
extends CssLayout {
    private static final TableFieldFactory FIELD_FACTORY = new DefaultFieldFactory(){
        private static final long serialVersionUID = 1L;

        public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
            Field result = null;
            if (CmsPermissionView.PROPERTY_ALLOWED.equals(propertyId) || CmsPermissionView.PROPERTY_DENIED.equals(propertyId)) {
                result = super.createField(container, itemId, propertyId, uiContext);
                result.setCaption("");
            }
            return result;
        }
    };
    private static final Log LOG = CmsLog.getLog(CmsPermissionView.class);
    private static final String PROPERTY_ALLOWED = "allowed";
    private static final String PROPERTY_DENIED = "denied";
    private static final String PROPERTY_DISPLAY_ALLOWED = "display_allowed";
    private static final String PROPERTY_DISPLAY_DENIED = "display_denied";
    private static final String PROPERTY_LABEL = "label";
    private static final String PROPERTY_VALUE = "value";
    private static final long serialVersionUID = 3440901877277200393L;
    private static final String UNKNOWN_TYPE = "Unknown";
    private VerticalLayout m_buttonBar;
    private PermissionChangeHandler m_changeHandler;
    private Button m_deleteButton;
    private CssLayout m_detailButtonContainer;
    private Button m_details;
    private boolean m_editable;
    private CmsAccessControlEntry m_entry;
    private CheckBox m_inheritCheckbox;
    private Label m_inheritedFrom;
    private Label m_label;
    private CheckBox m_overwriteCheckbox;
    private Table m_permissions;
    private String m_principalName;
    private String m_principalType;
    private CheckBox m_responsibleCheckbox;
    private Button m_setButton;

    public CmsPermissionView(CmsAccessControlEntry entry, boolean editable, boolean isFolder, String inheritedFrom, PermissionChangeHandler changeHandler) {
        String displayName;
        String niceName;
        I_CmsPrincipal principal;
        this.m_changeHandler = changeHandler;
        this.m_editable = editable;
        this.m_entry = entry;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            principal = CmsPrincipal.readPrincipalIncludingHistory(cms, entry.getPrincipal());
        }
        catch (CmsException e) {
            principal = null;
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_principalName = principal != null ? principal.getName() : entry.getPrincipal().toString();
        String ou = null;
        int flags = 0;
        if (principal != null && principal instanceof CmsHistoryPrincipal) {
            if (principal.isGroup()) {
                niceName = OpenCms.getWorkplaceManager().translateGroupName(principal.getName(), false);
                displayName = CmsVaadinUtils.getMessageText("GUI_ORGUNIT_DISPLAY_NAME_2", ((CmsHistoryPrincipal)principal).getDescription(), niceName);
                ou = CmsOrganizationalUnit.getParentFqn(this.m_principalName);
                flags = 32;
            } else {
                displayName = ((CmsHistoryPrincipal)principal).getName();
                ou = CmsOrganizationalUnit.getParentFqn(this.m_principalName);
                flags = 16;
            }
        } else if (principal != null && principal.isGroup()) {
            niceName = OpenCms.getWorkplaceManager().translateGroupName(principal.getName(), false);
            displayName = CmsVaadinUtils.getMessageText("GUI_ORGUNIT_DISPLAY_NAME_2", ((CmsGroup)principal).getDescription(A_CmsUI.get().getLocale()), niceName);
            ou = CmsOrganizationalUnit.getParentFqn(this.m_principalName);
            flags = 32;
        } else if (principal != null && principal.isUser()) {
            displayName = ((CmsUser)principal).getFullName();
            ou = CmsOrganizationalUnit.getParentFqn(this.m_principalName);
            flags = 16;
        } else if (this.m_principalName != null && this.m_principalName.equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.toString())) {
            this.m_principalName = "ALL_OTHERS";
            displayName = CmsVaadinUtils.getMessageText("GUI_LABEL_ALLOTHERS_0", new Object[0]);
            this.m_responsibleCheckbox.setVisible(false);
            flags = 128;
        } else if (this.m_principalName != null && this.m_principalName.equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID.toString())) {
            this.m_principalName = "OVERWRITE_ALL";
            displayName = CmsVaadinUtils.getMessageText("GUI_LABEL_OVERWRITEALL_0", new Object[0]);
            flags = 256;
        } else {
            CmsRole role = CmsRole.valueOfId(entry.getPrincipal());
            if (role != null) {
                displayName = role.getName(A_CmsUI.get().getLocale());
                this.m_principalName = role.getRoleName();
                flags = 512;
            } else {
                displayName = entry.getPrincipal().toString();
            }
        }
        if (flags > 0 && (entry.getFlags() & flags) == 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle(A_CmsUI.get().getLocale()).key("ERR_INVALID_ACE_1", entry.toString()));
            }
            entry = new CmsAccessControlEntry(entry.getResource(), entry.getPrincipal(), entry.getAllowedPermissions(), entry.getDeniedPermissions(), entry.getFlags() | flags);
        } else if (entry.getFlags() < 16) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle(A_CmsUI.get().getLocale()).key("ERR_INVALID_ACE_1", entry.toString()));
            }
            entry = new CmsAccessControlEntry(entry.getResource(), entry.getPrincipal(), entry.getAllowedPermissions(), entry.getDeniedPermissions(), entry.getFlags() | 0x20);
        }
        this.m_principalType = this.getEntryType(entry.getFlags(), false);
        if (this.m_principalName == null) {
            this.m_principalName = "";
        }
        FontAwesome icon = null;
        boolean isOverwriteAll = false;
        switch (flags) {
            case 16: {
                icon = FontAwesome.USER;
                break;
            }
            case 32: {
                icon = FontAwesome.GROUP;
                break;
            }
            case 128: {
                icon = FontAwesome.GLOBE;
                break;
            }
            case 512: {
                icon = FontAwesome.GRADUATION_CAP;
                break;
            }
            case 256: {
                icon = FontAwesome.EXCLAMATION_CIRCLE;
                isOverwriteAll = true;
                break;
            }
            default: {
                icon = FontAwesome.QUESTION_CIRCLE;
            }
        }
        this.m_label.setContentMode(ContentMode.HTML);
        String ouName = null;
        if (ou != null) {
            try {
                ouName = OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, ou).getDisplayName(UI.getCurrent().getLocale());
            }
            catch (CmsException e) {
                LOG.debug((Object)"Error reading OU name.", (Throwable)e);
            }
        }
        this.m_label.setValue(icon.getHtml() + " <b>" + displayName + "</b> " + entry.getPermissions().getPermissionString() + (ouName != null ? "<br />" + ouName : ""));
        this.m_label.setWidthUndefined();
        this.m_details.setIcon((Resource)FontAwesome.PLUS_SQUARE_O);
        this.m_details.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPermissionView.this.toggleDetails();
            }
        });
        this.m_setButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPermissionView.this.setPermissions();
            }
        });
        this.m_deleteButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPermissionView.this.deletePermissionSet();
            }
        });
        if (inheritedFrom != null) {
            this.m_inheritedFrom.setValue(inheritedFrom);
        } else {
            this.m_inheritedFrom.setVisible(false);
        }
        if (isOverwriteAll) {
            this.setDetailButtonVisible(false);
            if (this.m_editable) {
                this.addComponent((Component)this.m_deleteButton, 2);
                this.m_deleteButton.addStyleName("o-permissions_delete");
            }
        } else {
            CmsPermissionSet permissions = entry.getPermissions();
            IndexedContainer container = this.getPermissionContainer(permissions);
            this.m_permissions.setContainerDataSource((Container)container);
            this.m_permissions.setColumnReorderingAllowed(false);
            this.m_permissions.setColumnHeader((Object)PROPERTY_LABEL, CmsVaadinUtils.getMessageText("GUI_PERMISSION_0", new Object[0]));
            this.m_permissions.setColumnHeader((Object)PROPERTY_ALLOWED, CmsVaadinUtils.getMessageText("GUI_PERMISSION_ALLOWED_0", new Object[0]));
            this.m_permissions.setColumnHeader((Object)PROPERTY_DISPLAY_ALLOWED, CmsVaadinUtils.getMessageText("GUI_PERMISSION_ALLOWED_0", new Object[0]));
            this.m_permissions.setColumnHeader((Object)PROPERTY_DENIED, CmsVaadinUtils.getMessageText("GUI_PERMISSION_DENIED_0", new Object[0]));
            this.m_permissions.setColumnHeader((Object)PROPERTY_DISPLAY_DENIED, CmsVaadinUtils.getMessageText("GUI_PERMISSION_DENIED_0", new Object[0]));
            this.m_permissions.setPageLength(5);
            this.m_permissions.setSortEnabled(false);
            if (this.m_editable) {
                this.toggleDetails();
                this.setDetailButtonVisible(false);
                this.m_permissions.setVisibleColumns(new Object[]{PROPERTY_LABEL, PROPERTY_ALLOWED, PROPERTY_DENIED});
                this.m_permissions.setTableFieldFactory(FIELD_FACTORY);
                this.m_permissions.setEditable(this.m_editable);
                this.m_responsibleCheckbox.setValue((Object)this.isResponsible(entry.getFlags()));
                this.m_overwriteCheckbox.setValue((Object)this.isOverWritingInherited(entry.getFlags()));
                this.m_inheritCheckbox.setVisible(isFolder);
                this.m_inheritCheckbox.setValue((Object)this.m_entry.isInheriting());
                this.m_buttonBar.setVisible(true);
            } else {
                this.m_permissions.setVisibleColumns(new Object[]{PROPERTY_LABEL, PROPERTY_DISPLAY_ALLOWED, PROPERTY_DISPLAY_DENIED});
            }
        }
    }

    public void hideDeniedColumn() {
        if (this.m_editable) {
            this.m_permissions.setVisibleColumns(new Object[]{PROPERTY_LABEL, PROPERTY_ALLOWED});
        } else {
            this.m_permissions.setVisibleColumns(new Object[]{PROPERTY_LABEL, PROPERTY_DISPLAY_ALLOWED});
        }
    }

    protected String getEntryType(int flags, boolean all) {
        for (int i = 0; i < this.getTypes(all).length; ++i) {
            if ((flags & this.getTypesInt()[i]) <= 0) continue;
            return this.getTypes(all)[i];
        }
        return UNKNOWN_TYPE;
    }

    protected String[] getTypes(boolean all) {
        if (!all) {
            String[] array = new String[3];
            return Arrays.asList(CmsPermissionDialog.PRINCIPAL_TYPES).subList(0, 3).toArray(array);
        }
        return CmsPermissionDialog.PRINCIPAL_TYPES;
    }

    protected int[] getTypesInt() {
        return CmsPermissionDialog.PRINCIPAL_TYPES_INT;
    }

    protected Boolean isAllowed(CmsPermissionSet p, int value) {
        if ((p.getAllowedPermissions() & value) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Boolean isDenied(CmsPermissionSet p, int value) {
        if ((p.getDeniedPermissions() & value) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Boolean isOverWritingInherited(int flags) {
        if ((flags & 4) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Boolean isResponsible(int flags) {
        if ((flags & 0x40) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    void deletePermissionSet() {
        this.m_changeHandler.deletePermissionSet(this.m_principalType, this.m_principalName);
    }

    IndexedContainer getPermissionContainer(CmsPermissionSet permissions) {
        IndexedContainer result = new IndexedContainer();
        result.addContainerProperty((Object)PROPERTY_LABEL, String.class, (Object)"");
        result.addContainerProperty((Object)PROPERTY_VALUE, Integer.class, null);
        result.addContainerProperty((Object)PROPERTY_ALLOWED, Boolean.class, (Object)Boolean.FALSE);
        result.addContainerProperty((Object)PROPERTY_DISPLAY_ALLOWED, Label.class, null);
        result.addContainerProperty((Object)PROPERTY_DENIED, Boolean.class, (Object)Boolean.FALSE);
        result.addContainerProperty((Object)PROPERTY_DISPLAY_DENIED, Label.class, null);
        for (String key : CmsPermissionSet.getPermissionKeys()) {
            int flag = CmsPermissionSet.getPermissionValue(key);
            Item entry = result.addItem((Object)key);
            entry.getItemProperty((Object)PROPERTY_LABEL).setValue((Object)CmsVaadinUtils.getMessageText(key, new Object[0]));
            entry.getItemProperty((Object)PROPERTY_ALLOWED).setValue((Object)this.isAllowed(permissions, flag));
            entry.getItemProperty((Object)PROPERTY_DISPLAY_ALLOWED).setValue((Object)this.getCheckBoxLabel(this.isAllowed(permissions, flag)));
            entry.getItemProperty((Object)PROPERTY_DENIED).setValue((Object)this.isDenied(permissions, flag));
            entry.getItemProperty((Object)PROPERTY_DISPLAY_DENIED).setValue((Object)this.getCheckBoxLabel(this.isDenied(permissions, flag)));
            entry.getItemProperty((Object)PROPERTY_VALUE).setValue((Object)flag);
        }
        return result;
    }

    void setPermissions() {
        IndexedContainer container = (IndexedContainer)this.m_permissions.getContainerDataSource();
        int allowed = 0;
        int denied = 0;
        for (Object itemId : container.getItemIds()) {
            Item item = container.getItem(itemId);
            Integer value = (Integer)item.getItemProperty((Object)PROPERTY_VALUE).getValue();
            if (((Boolean)item.getItemProperty((Object)PROPERTY_ALLOWED).getValue()).booleanValue()) {
                allowed |= value.intValue();
            }
            if (!((Boolean)item.getItemProperty((Object)PROPERTY_DENIED).getValue()).booleanValue()) continue;
            denied |= value.intValue();
        }
        int flags = this.m_entry.getFlags();
        flags = ((Boolean)this.m_inheritCheckbox.getValue()).booleanValue() ? (flags |= 2) : (flags &= 0xFFFFFFFD);
        flags = ((Boolean)this.m_overwriteCheckbox.getValue()).booleanValue() ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        flags = ((Boolean)this.m_responsibleCheckbox.getValue()).booleanValue() ? (flags |= 0x40) : (flags &= 0xFFFFFFBF);
        this.m_changeHandler.setPermissions(this.m_principalType, this.m_principalName, allowed, denied, flags);
    }

    void toggleDetails() {
        if (this.m_permissions.isVisible()) {
            this.m_permissions.setVisible(false);
            this.m_details.setIcon((Resource)FontAwesome.PLUS_SQUARE_O);
        } else {
            this.m_permissions.setVisible(true);
            this.m_details.setIcon((Resource)FontAwesome.MINUS_SQUARE_O);
        }
        this.m_changeHandler.onViewChange();
    }

    private Label getCheckBoxLabel(Boolean value) {
        String content = value != false ? "<input type='checkbox' disabled='true' checked='true' />" : "<input type='checkbox' disabled='true' />";
        return new Label(content, ContentMode.HTML);
    }

    private void setDetailButtonVisible(boolean visible) {
        this.m_detailButtonContainer.setVisible(visible);
        if (visible) {
            this.removeStyleName("o-permission-no-details");
        } else {
            this.addStyleName("o-permission-no-details");
        }
    }

    public static interface PermissionChangeHandler {
        public void deletePermissionSet(String var1, String var2);

        public void onViewChange();

        public void setPermissions(String var1, String var2, int var3, int var4, int var5);
    }
}

