/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.google.common.collect.Maps;
import com.vaadin.annotations.DesignRoot;
import com.vaadin.server.ClientConnector;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.OptionGroup;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.login.CmsLoginController;
import org.opencms.ui.login.CmsLoginHelper;
import org.opencms.ui.login.CmsLoginOuSelector;
import org.opencms.workplace.CmsWorkplaceMessages;

@DesignRoot
public class CmsLoginForm
extends VerticalLayout {
    public static final String PC_TYPE_PRIVATE = "private";
    public static final String PC_TYPE_PUBLIC = "public";
    private static final long serialVersionUID = 1L;
    protected CmsLoginController m_controller;
    private Label m_copyright;
    private Label m_error;
    private Button m_forgotPasswordButton;
    private Button m_loginButton;
    private Button m_optionsButton;
    private boolean m_optionsVisible;
    private CmsLoginOuSelector m_ouSelect;
    private TextField m_passwordField;
    private OptionGroup m_securityField;
    private TextField m_userField;

    public CmsLoginForm(CmsLoginController controller, Locale locale) {
        this.m_controller = controller;
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(locale);
        HashMap macros = Maps.newHashMap();
        macros.put("showSecure", "" + controller.isShowSecure());
        String pctype = controller.getPcType();
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, messages, macros);
        this.m_securityField.addItem((Object)PC_TYPE_PUBLIC);
        this.m_securityField.addItem((Object)PC_TYPE_PRIVATE);
        this.m_securityField.setValue((Object)pctype);
        this.m_copyright.setContentMode(ContentMode.HTML);
        this.m_copyright.setValue(CmsLoginHelper.getCopyrightHtml(locale));
        this.m_securityField.setItemCaption((Object)PC_TYPE_PRIVATE, messages.key("GUI_LOGIN_PCTYPE_PRIVATE_0"));
        this.m_securityField.setItemCaption((Object)PC_TYPE_PUBLIC, messages.key("GUI_LOGIN_PCTYPE_PUBLIC_0"));
        this.setWidth("600px");
        this.m_loginButton.setClickShortcut(13, new int[0]);
        this.m_loginButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLoginForm.this.m_controller.onClickLogin();
            }
        });
        this.addAttachListener(new ClientConnector.AttachListener(){
            private static final long serialVersionUID = 1L;

            public void attach(ClientConnector.AttachEvent event) {
                CmsLoginForm.this.m_userField.focus();
            }
        });
        Button.ClickListener forgotPasswordListener = new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLoginForm.this.m_controller.onClickForgotPassword();
            }
        };
        this.m_forgotPasswordButton.addClickListener(forgotPasswordListener);
        this.m_optionsButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLoginForm.this.toggleOptionsVisible();
            }
        });
        this.setOptionsVisible(false);
        this.m_error.setContentMode(ContentMode.HTML);
    }

    public String getOrgUnit() {
        return this.m_ouSelect.getValue();
    }

    public String getPassword() {
        return (String)this.m_passwordField.getValue();
    }

    public String getPcType() {
        return "" + this.m_securityField.getValue();
    }

    public String getUser() {
        return (String)this.m_userField.getValue();
    }

    public void selectOrgUnit(String preselectedOu) {
        this.m_ouSelect.setValue(preselectedOu);
    }

    public void setOptionsVisible(boolean optionsVisible) {
        this.m_optionsVisible = optionsVisible;
        boolean ousVisible = optionsVisible && !this.m_ouSelect.isAlwaysHidden();
        this.m_ouSelect.setVisible(ousVisible);
        this.m_forgotPasswordButton.setVisible(optionsVisible);
        String optionsMessage = CmsVaadinUtils.getMessageText(optionsVisible ? "GUI_LOGIN_OPTIONS_HIDE_0" : "GUI_LOGIN_OPTIONS_SHOW_0", new Object[0]);
        this.m_optionsButton.setCaption(optionsMessage);
    }

    public void setSelectableOrgUnits(List<CmsOrganizationalUnit> ous) {
        this.m_ouSelect.initOrgUnits(ous);
    }

    public void toggleOptionsVisible() {
        this.setOptionsVisible(!this.m_optionsVisible);
    }

    void displayError(String messageHTML) {
        this.m_error.setValue(messageHTML);
        this.m_error.setVisible(true);
    }
}

