/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;

public class CmsTokenValidator {
    public static final String ADDINFO_KEY = "RESET_AUTH";
    private CmsUser m_user;

    public static void clearToken(CmsObject cms, CmsUser user) throws CmsException {
        user.getAdditionalInfo().remove(ADDINFO_KEY);
        cms.writeUser(user);
    }

    public static String createToken(CmsObject cms, CmsUser user, long currentTime) throws CmsException {
        String randomKey = RandomStringUtils.randomAlphanumeric((int)8);
        String value = CmsEncoder.encodeStringsAsBase64Parameter(Arrays.asList(randomKey, "" + currentTime));
        user.setAdditionalInfo(ADDINFO_KEY, value);
        cms.writeUser(user);
        return CmsEncoder.encodeStringsAsBase64Parameter(Arrays.asList(user.getName(), randomKey));
    }

    public CmsUser getUser() {
        return this.m_user;
    }

    public String validateToken(CmsObject cms, String token, long maxAgeMillis) throws CmsException {
        try {
            List<String> tokenValues = CmsEncoder.decodeStringsFromBase64Parameter(token);
            if (tokenValues.size() != 2) {
                return "Invalid token";
            }
            CmsUser user = cms.readUser(tokenValues.get(0));
            String userValue = (String)user.getAdditionalInfo(ADDINFO_KEY);
            if (userValue == null) {
                return "no additional infos found";
            }
            List<String> userValues = CmsEncoder.decodeStringsFromBase64Parameter(userValue);
            if (userValues.get(0).equals(tokenValues.get(1))) {
                String strUserTime = userValues.get(1);
                long usertime = Long.valueOf(strUserTime);
                if (System.currentTimeMillis() - usertime > maxAgeMillis) {
                    return "Auth token too old";
                }
                this.m_user = user;
                return null;
            }
            return "Key mismatch";
        }
        catch (IllegalArgumentException e) {
            return "Token parse error";
        }
        catch (CmsDataAccessException e) {
            return "User not found";
        }
    }
}

