/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.report;

import com.google.gwt.event.shared.HandlerRegistration;
import com.vaadin.server.Page;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.JavaScript;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.report.CmsReportWidget;

public class CmsReportOverlay
extends CustomLayout {
    private static final long serialVersionUID = 12519444651216053L;
    private static final Log LOG = CmsLog.getLog(CmsReportOverlay.class);
    private static final int REPORT_VIEW_DELAY = 5000;
    CmsReportWidget m_report;

    public CmsReportOverlay(A_CmsReportThread thread) {
        this.setId(RandomStringUtils.randomAlphabetic((int)8));
        try {
            InputStream layoutStream = CmsVaadinUtils.readCustomLayout(((Object)((Object)this)).getClass(), "reportoverlay.html");
            this.initTemplateContentsFromInputStream(layoutStream);
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_report = new CmsReportWidget(thread);
        this.m_report.setWidth("100%");
        this.m_report.setHeight(Page.getCurrent().getBrowserWindowHeight() - 200 + "px");
        CmsBasicDialog dialogContent = new CmsBasicDialog();
        dialogContent.setContent((Component)this.m_report);
        this.addComponent((Component)dialogContent, "content");
        this.m_report.addReportFinishedHandler(new Runnable(){

            @Override
            public void run() {
                CmsReportOverlay.this.setVisible(false);
            }
        });
        JavaScript.eval((String)("setTimeout(function(){ var el= document.getElementById('" + this.getId() + "'); if (el!=null) el.classList.add('o-report-show'); }," + 5000 + ")"));
    }

    public HandlerRegistration addReportFinishedHandler(Runnable handler) {
        return this.m_report.addReportFinishedHandler(handler);
    }

    public void setTitle(String title) {
        JavaScript.eval((String)("document.querySelector('#" + this.getId() + " .fakewindowheader').innerHTML = '" + StringEscapeUtils.escapeJavaScript((String)title) + "'"));
    }
}

