/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.report;

import com.google.common.collect.Lists;
import com.google.gwt.event.shared.HandlerRegistration;
import com.vaadin.ui.AbstractComponent;
import java.util.List;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.shared.components.CmsReportWidgetState;
import org.opencms.ui.shared.rpc.I_CmsReportClientRpc;
import org.opencms.ui.shared.rpc.I_CmsReportServerRpc;

public class CmsReportWidget
extends AbstractComponent
implements I_CmsReportServerRpc {
    private static final long serialVersionUID = 1L;
    private List<Runnable> m_reportFinishedHandlers = Lists.newArrayList();
    private A_CmsReportThread m_thread;
    private boolean m_threadFinished;

    public CmsReportWidget() {
        this.registerRpc(this, I_CmsReportServerRpc.class);
    }

    public CmsReportWidget(A_CmsReportThread thread) {
        this();
        this.m_thread = thread;
    }

    public HandlerRegistration addReportFinishedHandler(final Runnable handler) {
        this.m_reportFinishedHandlers.add(handler);
        return new HandlerRegistration(){

            public void removeHandler() {
                CmsReportWidget.this.m_reportFinishedHandlers.remove(handler);
            }
        };
    }

    @Override
    public void requestReportUpdate() {
        String reportUpdate = null;
        if (!this.m_threadFinished && this.m_thread != null) {
            reportUpdate = this.m_thread.getReportUpdate();
            if (!this.m_thread.isAlive()) {
                this.m_threadFinished = true;
                for (Runnable handler : this.m_reportFinishedHandlers) {
                    handler.run();
                }
            }
        }
        ((I_CmsReportClientRpc)this.getRpcProxy(I_CmsReportClientRpc.class)).handleReportUpdate(reportUpdate);
    }

    public void setReportThread(A_CmsReportThread thread) {
        this.m_thread = thread;
    }

    protected CmsReportWidgetState getState() {
        return (CmsReportWidgetState)super.getState();
    }
}

