/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.sitemap;

import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Notification;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.tools.CmsContainerPageCopier;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsCopyPageDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsCopyPageDialog.class);
    private static final long serialVersionUID = 1L;
    private Button m_cancelButton;
    private I_CmsDialogContext m_context;
    private ComboBox m_copyMode = new ComboBox();
    private Button m_okButton;
    private CmsPathSelectField m_targetSelect;

    public CmsCopyPageDialog(I_CmsDialogContext context) {
        this.m_context = context;
        this.displayResourceInfo(context.getResources());
        this.initButtons();
        this.m_copyMode.setNullSelectionAllowed(false);
        this.setContent((Component)this.initContent());
    }

    void initButtons() {
        this.m_okButton = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_OK_0", new Object[0]));
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsCopyPageDialog.this.onClickOk();
            }
        });
        this.addButton((Component)this.m_okButton);
        this.m_cancelButton = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CANCEL_0", new Object[0]));
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsCopyPageDialog.this.m_context.finish(new ArrayList<CmsUUID>());
            }
        });
        this.addButton((Component)this.m_cancelButton);
    }

    void onClickOk() {
        CmsContainerPageCopier copier = new CmsContainerPageCopier(this.m_context.getCms());
        try {
            CmsContainerPageCopier.CopyMode mode = (CmsContainerPageCopier.CopyMode)((Object)this.m_copyMode.getValue());
            copier.setCopyMode(mode);
            TargetInfo info = new TargetInfo(this.m_context.getCms(), this.m_targetSelect.getValue());
            if (!info.isValid()) {
                Notification.Type type = Notification.Type.ERROR_MESSAGE;
                String error = CmsVaadinUtils.getMessageText("GUI_COPYPAGE_INVALID_TARGET_0", new Object[0]);
                Notification.show((String)error, (Notification.Type)type);
                return;
            }
            CmsResource targetFolder = info.getTargetFolder();
            copier.run(this.m_context.getResources().get(0), targetFolder, info.getTargetName());
            this.m_context.finish(Arrays.asList(copier.getTargetFolder().getStructureId(), copier.getCopiedFolderOrPage().getStructureId()));
        }
        catch (CmsException e) {
            this.m_context.error(e);
        }
        catch (CmsContainerPageCopier.NoCustomReplacementException e) {
            String errorMessage = CmsVaadinUtils.getMessageText("GUI_COPYPAGE_NO_REPLACEMENT_FOUND_1", e.getResource().getRootPath());
            CmsErrorDialog.showErrorDialog(errorMessage, e);
        }
    }

    private String getInitialTarget(CmsObject cms, CmsResource resource) {
        String sitePath = cms.getSitePath(resource);
        String parent = CmsResource.getParentFolder(sitePath);
        if (parent != null) {
            return parent;
        }
        String rootParent = CmsResource.getParentFolder(resource.getRootPath());
        if (rootParent != null) {
            return rootParent;
        }
        return sitePath;
    }

    private FormLayout initContent() {
        FormLayout form = new FormLayout();
        CmsPathSelectField field = new CmsPathSelectField();
        field.setValue(this.getInitialTarget(this.m_context.getCms(), this.m_context.getResources().get(0)));
        field.setStartWithSitempaView(true);
        field.setResourceFilter(CmsResourceFilter.IGNORE_EXPIRATION.addRequireFolder());
        field.setCaption(CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_TARGET_0", new Object[0]));
        form.addComponent((Component)field);
        this.m_targetSelect = field;
        this.m_copyMode.addItem((Object)CmsContainerPageCopier.CopyMode.automatic);
        this.m_copyMode.setItemCaption((Object)CmsContainerPageCopier.CopyMode.automatic, CmsVaadinUtils.getMessageText("GUI_COPYPAGE_MODE_AUTO_0", new Object[0]));
        this.m_copyMode.addItem((Object)CmsContainerPageCopier.CopyMode.smartCopyAndChangeLocale);
        this.m_copyMode.setItemCaption((Object)CmsContainerPageCopier.CopyMode.smartCopyAndChangeLocale, CmsVaadinUtils.getMessageText("GUI_COPYPAGE_MODE_SMART_0", new Object[0]));
        this.m_copyMode.addItem((Object)CmsContainerPageCopier.CopyMode.reuse);
        this.m_copyMode.setItemCaption((Object)CmsContainerPageCopier.CopyMode.reuse, CmsVaadinUtils.getMessageText("GUI_COPYPAGE_MODE_REUSE_0", new Object[0]));
        this.m_copyMode.setValue((Object)CmsContainerPageCopier.CopyMode.automatic);
        form.addComponent((Component)this.m_copyMode);
        this.m_copyMode.setCaption(CmsVaadinUtils.getMessageText("GUI_COPYPAGE_COPY_MODE_0", new Object[0]));
        return form;
    }

    public class TargetInfo {
        private boolean m_isFile;
        private CmsResource m_targetFolder;
        private String m_targetName;

        public TargetInfo(CmsObject cms, String path) {
            try {
                CmsResource resource;
                if (CmsStringUtil.isPrefixPath("/sites", path) || OpenCms.getSiteManager().getSiteForRootPath(path) != null) {
                    cms = OpenCms.initCmsObject(cms);
                    cms.getRequestContext().setSiteRoot("");
                }
                if ((resource = this.readIfExists(cms, path)) != null) {
                    if (resource.isFile()) {
                        this.m_isFile = true;
                    } else {
                        this.m_targetFolder = resource;
                    }
                    return;
                }
                resource = this.readIfExists(cms, CmsResource.getParentFolder(path));
                if (resource != null) {
                    if (resource.isFile()) {
                        this.m_isFile = true;
                    } else {
                        this.m_targetFolder = resource;
                        this.m_targetName = CmsResource.getName(path);
                    }
                    return;
                }
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }

        public CmsResource getTargetFolder() {
            return this.m_targetFolder;
        }

        public String getTargetName() {
            return this.m_targetName;
        }

        public boolean isFile() {
            return this.m_isFile;
        }

        public boolean isValid() {
            return this.m_targetFolder != null;
        }

        private CmsResource readIfExists(CmsObject cms, String path) {
            if (cms.existsResource(path, CmsResourceFilter.IGNORE_EXPIRATION)) {
                try {
                    return cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return null;
                }
            }
            return null;
        }
    }
}

