/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.apache.commons.collections.Closure;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.Messages;

public final class CmsFileUtil {
    private static final Log LOG = CmsLog.getLog(CmsFileUtil.class);

    private CmsFileUtil() {
    }

    public static String addTrailingSeparator(String path) {
        int l = path.length();
        if (l == 0 || path.charAt(l - 1) != '/') {
            return path.concat("/");
        }
        return path;
    }

    public static void checkResources(CmsObject cms, List<String> resources) throws CmsIllegalArgumentException {
        StringBuffer result = new StringBuffer(128);
        ListIterator<String> it = resources.listIterator();
        while (it.hasNext()) {
            String resourcePath = it.next();
            try {
                CmsResource resource = cms.readResource(resourcePath);
                if (!resource.isFolder() || resourcePath.endsWith("/")) continue;
                it.set(resourcePath + "/");
            }
            catch (CmsException e) {
                result.append(resourcePath);
                result.append('\n');
            }
        }
        if (result.length() > 0) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_MISSING_RESOURCES_1", result.toString()));
        }
    }

    public static void copy(String fromFile, String toFile) throws IOException {
        int len;
        File inputFile = new File(fromFile);
        File outputFile = new File(toFile);
        if (!outputFile.getParentFile().isDirectory()) {
            outputFile.getParentFile().mkdirs();
        }
        FileInputStream in = new FileInputStream(inputFile);
        FileOutputStream out = new FileOutputStream(outputFile);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    public static String formatFilesize(long filesize, Locale locale) {
        String result = Math.abs(filesize = Math.abs(filesize)) < 1024L ? Messages.get().getBundle(locale).key("GUI_FILEUTIL_FILESIZE_BYTES_1", new Long(filesize)) : (Math.abs(filesize) < 0x100000L ? Messages.get().getBundle(locale).key("GUI_FILEUTIL_FILESIZE_KBYTES_1", new Double((double)filesize / 1024.0)) : (Math.abs(filesize) < 0x40000000L ? Messages.get().getBundle(locale).key("GUI_FILEUTIL_FILESIZE_MBYTES_1", new Double((double)filesize / 1048576.0)) : Messages.get().getBundle(locale).key("GUI_FILEUTIL_FILESIZE_GBYTES_1", new Double((double)filesize / 1.073741824E9))));
        return result;
    }

    public static String formatResourceNames(CmsRequestContext context, List<CmsResource> resources) {
        if (resources == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(128);
        Iterator<CmsResource> i = resources.iterator();
        while (i.hasNext()) {
            CmsResource res = i.next();
            String path = res.getRootPath();
            if (context != null) {
                path = context.removeSiteRoot(path);
            }
            result.append(path);
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String getEncoding(CmsObject cms, CmsResource file) {
        CmsProperty encodingProperty = CmsProperty.getNullProperty();
        try {
            encodingProperty = cms.readPropertyObject(file, "content-encoding", true);
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return CmsEncoder.lookupEncoding(encodingProperty.getValue(""), OpenCms.getSystemInfo().getDefaultEncoding());
    }

    public static String getExtension(String resourceName) {
        if (resourceName.charAt(resourceName.length() - 1) == '/') {
            return "";
        }
        String name = CmsResource.getName(resourceName);
        int pos = name.lastIndexOf(46);
        if (pos < 0 || pos + 1 == name.length()) {
            return "";
        }
        return name.substring(pos).toLowerCase();
    }

    @Deprecated
    public static String getFileExtension(String filename) {
        int pos = filename.lastIndexOf(46);
        return pos >= 0 ? filename.substring(pos).toLowerCase() : "";
    }

    public static List<File> getFiles(String name, FileFilter filter, boolean includeSubtree) {
        ArrayList<File> ret = new ArrayList<File>();
        File file = new File(name);
        if (!file.isDirectory() && !(file = new File(file.getParent())).isDirectory()) {
            return ret;
        }
        File[] dirContent = file.listFiles();
        for (int i = 0; i < dirContent.length; ++i) {
            File f = dirContent[i];
            if (filter.accept(f)) {
                ret.add(f);
            }
            if (!includeSubtree || !f.isDirectory()) continue;
            ret.addAll(CmsFileUtil.getFiles(f.getAbsolutePath(), filter, true));
        }
        return ret;
    }

    public static String getRepositoryName(String repository, String vfspath, boolean online) {
        StringBuffer result = new StringBuffer(64);
        result.append(repository);
        result.append(online ? "online" : "offline");
        result.append(vfspath);
        return result.toString();
    }

    public static String getRfsPath(String filename, String extension, String parameters) {
        StringBuffer buf = new StringBuffer(128);
        buf.append(filename);
        buf.append('_');
        int h = parameters.hashCode();
        buf.append(h > 0 ? h : -h);
        buf.append(extension);
        return buf.toString();
    }

    public static String normalizePath(String path) {
        return CmsFileUtil.normalizePath(path, File.separatorChar);
    }

    public static String normalizePath(String path, char separatorChar) {
        if (CmsStringUtil.isNotEmpty(path)) {
            String drive = null;
            if (path.length() > 1 && path.charAt(1) == ':') {
                drive = path.substring(0, 2);
                path = path.substring(2);
            } else if (path.length() > 1 && path.charAt(0) == '\\' && path.charAt(1) == '\\') {
                drive = path.substring(0, 2);
                path = path.substring(2);
            }
            path = path.replace('\\', '/');
            if (drive != null) {
                drive = drive.replace('\\', '/');
            }
            if (path.charAt(0) == '/') {
                path = '.' + path;
            }
            path = CmsLinkManager.getAbsoluteUri(path, "/");
            path = CmsStringUtil.substitute(path, "//", "/");
            if (drive != null) {
                path = drive.concat(path);
            }
            if (separatorChar != '/') {
                path = path.replace('/', separatorChar);
            }
        }
        return path;
    }

    public static String normalizePath(URL url) {
        return CmsFileUtil.normalizePath(url, File.separatorChar);
    }

    public static String normalizePath(URL url, char separatorChar) {
        String path = new File(url.getPath()).getAbsolutePath();
        String systemEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        return CmsFileUtil.normalizePath(CmsEncoder.decode(path, systemEncoding), separatorChar);
    }

    public static void purgeDirectory(File directory) {
        if (directory.canRead() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) {
                    CmsFileUtil.purgeDirectory(f);
                }
                if (!f.canWrite()) continue;
                f.delete();
            }
            directory.delete();
        }
    }

    public static byte[] readFile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        return CmsFileUtil.readFully((InputStream)in, (int)file.length());
    }

    public static byte[] readFile(String filename) throws IOException {
        InputStream in = CmsFileUtil.class.getClassLoader().getResourceAsStream(filename);
        if (in == null) {
            throw new FileNotFoundException(filename);
        }
        return CmsFileUtil.readFully(in);
    }

    public static String readFile(String filename, String encoding) throws IOException {
        return new String(CmsFileUtil.readFile(filename), encoding);
    }

    public static byte[] readFully(InputStream in) throws IOException {
        return CmsFileUtil.readFully(in, true);
    }

    public static byte[] readFully(InputStream in, boolean closeInputStream) throws IOException {
        if (in instanceof ByteArrayInputStream) {
            return CmsFileUtil.readFully(in, in.available(), closeInputStream);
        }
        byte[] xfer = new byte[2048];
        ByteArrayOutputStream out = new ByteArrayOutputStream(xfer.length);
        int bytesRead = in.read(xfer, 0, xfer.length);
        while (bytesRead >= 0) {
            if (bytesRead > 0) {
                out.write(xfer, 0, bytesRead);
            }
            bytesRead = in.read(xfer, 0, xfer.length);
        }
        if (closeInputStream) {
            in.close();
        }
        out.close();
        return out.toByteArray();
    }

    public static byte[] readFully(InputStream in, int size) throws IOException {
        return CmsFileUtil.readFully(in, size, true);
    }

    public static byte[] readFully(InputStream in, int size, boolean closeStream) throws IOException {
        int offset;
        byte[] bytes = new byte[size];
        int numRead = 0;
        for (offset = 0; offset < size && (numRead = in.read(bytes, offset, size - offset)) >= 0; offset += numRead) {
        }
        if (closeStream) {
            in.close();
        }
        if (offset < bytes.length) {
            throw new IOException("Could not read requested " + size + " bytes from input stream");
        }
        return bytes;
    }

    public static String removeLeadingSeparator(String path) {
        int l = path.length();
        if (l == 0) {
            return "";
        }
        if (path.charAt(0) != '/') {
            return path;
        }
        if (l == 1) {
            return "";
        }
        return path.substring(1, l);
    }

    public static List<String> removeRedundancies(List<String> resourcenames) {
        if (resourcenames == null || resourcenames.isEmpty()) {
            return new ArrayList<String>();
        }
        if (resourcenames.size() == 1) {
            return new ArrayList<String>(resourcenames);
        }
        ArrayList<String> result = new ArrayList<String>(resourcenames.size());
        ArrayList<String> base = new ArrayList<String>(resourcenames);
        Collections.sort(base);
        for (String resourcename : base) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(resourcename)) continue;
            boolean valid = true;
            for (int j = result.size() - 1; j >= 0; --j) {
                String check = (String)result.get(j);
                if ((!CmsResource.isFolder(check) || !resourcename.startsWith(check)) && !resourcename.equals(check)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            result.add(resourcename);
        }
        return result;
    }

    public static List<CmsResource> removeRedundantResources(List<CmsResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return new ArrayList<CmsResource>();
        }
        if (resources.size() == 1) {
            return new ArrayList<CmsResource>(resources);
        }
        ArrayList<CmsResource> result = new ArrayList<CmsResource>(resources.size());
        ArrayList<CmsResource> base = new ArrayList<CmsResource>(resources);
        Collections.sort(base);
        for (CmsResource resource : base) {
            boolean valid = true;
            for (int j = result.size() - 1; j >= 0; --j) {
                CmsResource check = (CmsResource)result.get(j);
                if ((!check.isFolder() || !resource.getRootPath().startsWith(check.getRootPath())) && !resource.getRootPath().equals(check.getRootPath())) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            result.add(resource);
        }
        return result;
    }

    public static String removeTrailingSeparator(String path) {
        int l = path.length();
        if (l <= 1 || path.charAt(l - 1) != '/') {
            return path;
        }
        return path.substring(0, l - 1);
    }

    public static String searchWebInfFolder(String startFolder) {
        File file;
        if (CmsStringUtil.isEmpty(startFolder)) {
            return null;
        }
        File f = new File(startFolder);
        if (!f.exists() || !f.isDirectory()) {
            return null;
        }
        File configFile = new File(f, "opencms.tld");
        if (configFile.exists() && configFile.isFile()) {
            return f.getAbsolutePath();
        }
        String webInfFolder = null;
        File[] subFiles = f.listFiles();
        ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(subFiles));
        Collections.sort(fileList, new Comparator<File>(){

            @Override
            public int compare(File arg0, File arg1) {
                boolean a = arg0.getPath().contains("WEB-INF");
                boolean b = arg1.getPath().contains("WEB-INF");
                return Boolean.valueOf(b).compareTo(a);
            }
        });
        Iterator iterator = fileList.iterator();
        while (iterator.hasNext() && (!(file = (File)iterator.next()).isDirectory() || (webInfFolder = CmsFileUtil.searchWebInfFolder(file.getAbsolutePath())) == null)) {
        }
        return webInfFolder;
    }

    public static void walkFileSystem(File base, Closure action) {
        ArrayList<FileWalkState> m_states = new ArrayList<FileWalkState>();
        m_states.add(CmsFileUtil.createFileWalkState(base));
        while (!m_states.isEmpty()) {
            FileWalkState last = (FileWalkState)m_states.remove(m_states.size() - 1);
            action.execute((Object)last);
            for (File dir : last.getDirectories()) {
                m_states.add(CmsFileUtil.createFileWalkState(dir));
            }
        }
    }

    private static FileWalkState createFileWalkState(File file) {
        File[] contents = file.listFiles();
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        for (File subFile : contents) {
            if (subFile.isDirectory()) {
                dirs.add(subFile);
                continue;
            }
            files.add(subFile);
        }
        return new FileWalkState(file, dirs, files);
    }

    public static class FileWalkState {
        private File m_currentDir;
        private List<File> m_directories;
        private List<File> m_files;

        public FileWalkState(File currentDir, List<File> dirs, List<File> files) {
            this.m_currentDir = currentDir;
            this.m_directories = dirs;
            this.m_files = files;
        }

        public File getCurrentDir() {
            return this.m_currentDir;
        }

        public List<File> getDirectories() {
            return this.m_directories;
        }

        public List<File> getFiles() {
            return this.m_files;
        }
    }
}

