/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.util.A_CmsHtmlConverter;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.util.Messages;
import org.w3c.tidy.Tidy;

public class CmsHtmlConverterJTidy
extends A_CmsHtmlConverter {
    private static final Log LOG = CmsLog.getLog(CmsHtmlConverterJTidy.class);
    String[] m_cleanupPatterns = new String[]{"<o:p>.*(\\r\\n)*.*</o:p>", "<o:p>.*(\\r\\n)*.*</O:p>", "<\\?xml:.*(\\r\\n).*/>", "<\\?xml:.*(\\r\\n).*(\\r\\n).*/\\?>", "<\\?xml:.*(\\r\\n).*(\\r\\n).*/>", "<\\?xml:(.*(\\r\\n)).*/\\?>", "<o:SmartTagType.*(\\r\\n)*.*/>", "<o:smarttagtype.*(\\r\\n)*.*/>"};
    Pattern[] m_clearStyle;
    String[] m_replaceParagraphPatterns = new String[]{"</ul>\n<br />", "</ol>\n<br />", "<p><br />", "<p>", "<br />(\\s)*&nbsp;(\\s)*</p>", "<br /></p>", "</p>", "^<br />", "<br />$"};
    String[] m_replaceParagraphValues = new String[]{"</ul>", "</ol>", "<br />", "<br />", "<br />", "<br />", "<br />", "", ""};
    String[] m_replacePatterns = new String[]{"&#160;", "(\\r\\n){2,}", "\u2013", "(\\n){2,}", "\\(\\r\\n<", "\\(\\n<", "\\(\\r\\n(\\ ){1,}<", "\\(\\n(\\ ){1,}<", "\\r\\n<span", "\\n<span"};
    Pattern[] m_replaceStyle;
    String[] m_replaceValues = new String[]{"&nbsp;", "", "&ndash;", "", "(<", "(<", "(<", "(<", "<span", "<span"};
    Tidy m_tidy;
    private int m_lineSeparatorLength;
    private boolean m_modeEnabled;
    private boolean m_modeReplaceParagraphs;
    private boolean m_modeWord;
    private boolean m_modeXhtml;
    private static final List<String> MODES_DEFAULT = Collections.unmodifiableList(Arrays.asList(CmsHtmlConverter.PARAM_ENABLED));

    public CmsHtmlConverterJTidy() {
        super(null, MODES_DEFAULT);
    }

    public CmsHtmlConverterJTidy(String encoding, List<String> modes) {
        super(encoding, modes);
    }

    @Override
    public String convertToString(String htmlInput) throws UnsupportedEncodingException {
        this.initModes();
        if (this.m_modeEnabled) {
            int max = this.m_modeWord ? 10 : 1;
            int count = 0;
            int oldSize = htmlInput.length();
            String workHtml = this.regExp(htmlInput);
            while (count < max) {
                ++count;
                if (this.m_modeWord) {
                    workHtml = this.adjustHtml(workHtml);
                }
                workHtml = this.parse(workHtml);
                if (this.m_modeWord) {
                    workHtml = workHtml.substring(0, workHtml.length() - this.m_lineSeparatorLength);
                }
                if (workHtml.length() == oldSize) {
                    workHtml = this.regExp(workHtml);
                    break;
                }
                oldSize = workHtml.length();
                workHtml = this.regExp(workHtml);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PARSING_RUNS_2", this.getClass().getName(), new Integer(count)));
            }
            htmlInput = workHtml;
        }
        return htmlInput;
    }

    private String adjustHtml(String htmlInput) {
        if (htmlInput.toLowerCase().indexOf("<html>") == -1 && htmlInput.toLowerCase().indexOf("</html>") == -1) {
            StringBuffer tmp = new StringBuffer();
            tmp.append("<html xmlns:o=\"\"><body>");
            tmp.append(htmlInput);
            tmp.append("</body></html>");
            htmlInput = tmp.toString();
        }
        return htmlInput;
    }

    private void initModes() {
        this.m_modeEnabled = false;
        this.m_modeReplaceParagraphs = false;
        this.m_modeWord = false;
        this.m_modeXhtml = false;
        List<String> modes = this.getModes();
        if (modes.contains(CmsHtmlConverter.PARAM_ENABLED)) {
            this.m_modeEnabled = true;
        }
        if (modes.contains("xhtml")) {
            this.m_modeEnabled = true;
            this.m_modeXhtml = true;
        }
        if (modes.contains("cleanup")) {
            this.m_modeEnabled = true;
            this.m_modeWord = true;
        }
        if (modes.contains("replace-paragraphs")) {
            this.m_modeEnabled = true;
            this.m_modeReplaceParagraphs = true;
        }
        this.m_lineSeparatorLength = System.getProperty("line.separator").length();
        if (this.m_modeEnabled) {
            int i;
            this.m_tidy = new Tidy();
            this.m_tidy.setXHTML(this.m_modeXhtml);
            this.m_tidy.setWord2000(this.m_modeWord);
            Properties additionalTags = new Properties();
            additionalTags.put("new-empty-tags", "o:smarttagtype");
            additionalTags.put("new-inline-tags", "o:smarttagtype");
            this.m_tidy.getConfiguration().addProps(additionalTags);
            this.m_tidy.setInputEncoding(this.getEncoding());
            this.m_tidy.setOutputEncoding(this.getEncoding());
            this.m_tidy.setTidyMark(false);
            this.m_tidy.setMakeClean(false);
            this.m_tidy.setNumEntities(true);
            this.m_tidy.setPrintBodyOnly(true);
            this.m_tidy.setForceOutput(true);
            this.m_tidy.setQuiet(true);
            this.m_tidy.setShowWarnings(false);
            this.m_tidy.setHideComments(false);
            this.m_tidy.setBreakBeforeBR(false);
            this.m_tidy.setWrapAttVals(false);
            this.m_tidy.setWraplen(100);
            this.m_tidy.setSpaces(0);
            if (this.m_modeWord) {
                this.m_clearStyle = new Pattern[this.m_cleanupPatterns.length];
                for (i = 0; i < this.m_cleanupPatterns.length; ++i) {
                    this.m_clearStyle[i] = Pattern.compile(this.m_cleanupPatterns[i]);
                }
            }
            if (this.m_modeReplaceParagraphs) {
                String[] newPatterns = new String[this.m_replacePatterns.length + this.m_replaceParagraphPatterns.length];
                String[] newValues = new String[this.m_replacePatterns.length + this.m_replaceParagraphPatterns.length];
                System.arraycopy(this.m_replacePatterns, 0, newPatterns, 0, this.m_replacePatterns.length);
                System.arraycopy(this.m_replaceParagraphPatterns, 0, newPatterns, this.m_replacePatterns.length, this.m_replaceParagraphPatterns.length);
                System.arraycopy(this.m_replaceValues, 0, newValues, 0, this.m_replacePatterns.length);
                System.arraycopy(this.m_replaceParagraphValues, 0, newValues, this.m_replacePatterns.length, this.m_replaceParagraphPatterns.length);
                this.m_replacePatterns = newPatterns;
                this.m_replaceValues = newValues;
            }
            this.m_replaceStyle = new Pattern[this.m_replacePatterns.length];
            for (i = 0; i < this.m_replacePatterns.length; ++i) {
                this.m_replaceStyle[i] = Pattern.compile(this.m_replacePatterns[i]);
            }
        }
    }

    private String parse(String htmlInput) throws UnsupportedEncodingException {
        ByteArrayInputStream in = new ByteArrayInputStream(htmlInput.getBytes(this.getEncoding()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.m_tidy.parse((InputStream)in, (OutputStream)out);
        byte[] result = out.toByteArray();
        return new String(result, this.getEncoding());
    }

    private String regExp(String htmlInput) {
        int i;
        String parsedHtml = htmlInput.trim();
        if (this.m_modeWord) {
            for (i = 0; i < this.m_cleanupPatterns.length; ++i) {
                parsedHtml = this.m_clearStyle[i].matcher(parsedHtml).replaceAll("");
            }
        }
        for (i = 0; i < this.m_replacePatterns.length; ++i) {
            parsedHtml = this.m_replaceStyle[i].matcher(parsedHtml).replaceAll(this.m_replaceValues[i]);
        }
        return parsedHtml;
    }
}

