/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CmsPathTree<P, V> {
    private Map<P, CmsPathTree<P, V>> m_children = Maps.newHashMap();
    private V m_value;

    public void collectEntries(Collection<V> target) {
        if (this.m_value != null) {
            target.add(this.m_value);
        }
        for (CmsPathTree<P, V> child : this.m_children.values()) {
            child.collectEntries(target);
        }
    }

    public CmsPathTree<P, V> findNode(List<P> path) {
        LinkedList pathToConsume = Lists.newLinkedList(path);
        CmsPathTree<P, V> descendant = this.findNodeInternal(pathToConsume);
        if (!pathToConsume.isEmpty()) {
            return null;
        }
        return descendant;
    }

    public CmsPathTree<P, V> getChild(P pathPart) {
        return this.m_children.get(pathPart);
    }

    public List<V> getChildValues() {
        ArrayList result = Lists.newArrayList();
        for (CmsPathTree<P, V> child : this.m_children.values()) {
            if (child.m_value == null) continue;
            result.add(child.m_value);
        }
        return result;
    }

    public List<V> getChildValues(List<P> path) {
        CmsPathTree<P, V> descendant = this.findNode(path);
        if (descendant != null) {
            return descendant.getChildValues();
        }
        return Collections.emptyList();
    }

    public List<V> getDescendantValues(List<P> path) {
        CmsPathTree<P, V> node = this.findNode(path);
        ArrayList result = Lists.newArrayList();
        if (node != null) {
            node.collectEntries(result);
        }
        return result;
    }

    public V getValue() {
        return this.m_value;
    }

    public V getValue(List<P> path) {
        CmsPathTree<P, V> node = this.findNode(path);
        if (node != null) {
            return node.m_value;
        }
        return null;
    }

    public void setValue(List<P> path, V value) {
        this.ensureNode(path).setValue(value);
    }

    public void setValue(V value) {
        this.m_value = value;
    }

    private CmsPathTree<P, V> ensureNode(List<P> path) {
        CmsPathTree<P, V> lastExistingNode;
        LinkedList pathToConsume = Lists.newLinkedList(path);
        CmsPathTree<P, V> currentNode = lastExistingNode = this.findNodeInternal(pathToConsume);
        for (Object pathPart : pathToConsume) {
            CmsPathTree<P, V> child = new CmsPathTree<P, V>();
            currentNode.m_children.put(pathPart, child);
            currentNode = child;
        }
        return currentNode;
    }

    private CmsPathTree<P, V> findNodeInternal(List<P> pathToConsume) {
        Iterator<P> iter = pathToConsume.iterator();
        CmsPathTree<P, V> currentNode = this;
        while (iter.hasNext()) {
            CmsPathTree<P, V> child = currentNode.getChild(iter.next());
            if (child != null) {
                iter.remove();
                currentNode = child;
                continue;
            }
            return currentNode;
        }
        return currentNode;
    }
}

