/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.flex.CmsFlexResponse;
import org.opencms.i18n.CmsEncoder;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUriSplitter;
import org.opencms.util.Messages;

public final class CmsRequestUtil {
    public static final String ATTRIBUTE_ERRORCODE = "org.opencms.util.CmsErrorCode";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    public static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_CONNECTION = "Connection";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_JSESSIONID = "JSESSIONID";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_OPENCMS_EXPORT = "OpenCms-Export";
    public static final String HEADER_PRAGMA = "Pragma";
    public static final String HEADER_SERVER = "Server";
    public static final String HEADER_USER_AGENT = "user-agent";
    public static final String HEADER_VALUE_MAX_AGE = "max-age=";
    public static final String HEADER_VALUE_MUST_REVALIDATE = "must-revalidate";
    public static final String HEADER_VALUE_NO_CACHE = "no-cache";
    public static final String HEADER_VALUE_NO_STORE = "no-store";
    public static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String HEADER_X_FORWARDED_FOR = "x-forwarded-for";
    public static final String PARAMETER_ASSIGNMENT = "=";
    public static final String PARAMETER_DELIMITER = "&";
    public static final String URL_DELIMITER = "?";
    private static final String AMP = "amp;";
    private static final Log LOG = CmsLog.getLog(CmsRequestUtil.class);

    private CmsRequestUtil() {
    }

    public static String appendParameter(String url, String paramName, String paramValue) {
        if (CmsStringUtil.isEmpty(url)) {
            return null;
        }
        int pos = url.indexOf(URL_DELIMITER);
        StringBuffer result = new StringBuffer(256);
        result.append(url);
        if (pos >= 0) {
            result.append(PARAMETER_DELIMITER);
        } else {
            result.append(URL_DELIMITER);
        }
        result.append(paramName);
        result.append(PARAMETER_ASSIGNMENT);
        result.append(paramValue);
        return result.toString();
    }

    public static String appendParameters(String url, Map<String, String[]> params, boolean encode) {
        if (CmsStringUtil.isEmpty(url)) {
            return null;
        }
        if (params == null || params.isEmpty()) {
            return url;
        }
        int pos = url.indexOf(URL_DELIMITER);
        StringBuffer result = new StringBuffer(256);
        result.append(url);
        if (pos >= 0) {
            result.append(PARAMETER_DELIMITER);
        } else {
            result.append(URL_DELIMITER);
        }
        Iterator<Map.Entry<String, String[]>> i = params.entrySet().iterator();
        while (i.hasNext()) {
            String[] stringArray;
            Map.Entry<String, String[]> entry = i.next();
            String key = entry.getKey();
            String[] value = entry.getValue();
            if (value instanceof String[]) {
                stringArray = value;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value.toString();
            }
            String[] values = stringArray;
            for (int j = 0; j < values.length; ++j) {
                String strValue = values[j];
                if (encode) {
                    strValue = CmsEncoder.encode(strValue);
                }
                result.append(key);
                result.append(PARAMETER_ASSIGNMENT);
                result.append(strValue);
                if (j + 1 >= values.length) continue;
                result.append(PARAMETER_DELIMITER);
            }
            if (!i.hasNext()) continue;
            result.append(PARAMETER_DELIMITER);
        }
        return result.toString();
    }

    public static Map<String, String[]> createParameterMap(Map<String, ?> params) {
        if (params == null) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String key = entry.getKey();
            Object values = entry.getValue();
            if (values instanceof String[]) {
                result.put(key, (String[])values);
                continue;
            }
            if (values == null) continue;
            result.put(key, new String[]{values.toString()});
        }
        return result;
    }

    public static Map<String, String[]> createParameterMap(String query) {
        return CmsRequestUtil.createParameterMap(query, false, null);
    }

    public static Map<String, String[]> createParameterMap(String query, boolean decodeParameters, String encoding) {
        if (CmsStringUtil.isEmpty(query)) {
            return new HashMap<String, String[]>();
        }
        if (query.charAt(0) == URL_DELIMITER.charAt(0)) {
            query = query.substring(1);
        }
        String[] params = CmsStringUtil.splitAsArray(query, PARAMETER_DELIMITER);
        HashMap<String, String[]> parameters = new HashMap<String, String[]>(params.length);
        for (int i = 0; i < params.length; ++i) {
            String[] values;
            String key = null;
            String value = null;
            int pos = params[i].indexOf(PARAMETER_ASSIGNMENT);
            if (pos > 0) {
                key = params[i].substring(0, pos);
                value = params[i].substring(pos + 1);
            } else if (pos < 0) {
                key = params[i];
                value = "";
            }
            if (key != null && key.startsWith(AMP)) {
                key = key.substring(AMP.length());
            }
            if (key == null) continue;
            if (decodeParameters) {
                key = CmsEncoder.decode(key, encoding);
                value = CmsEncoder.decode(value, encoding);
            }
            if ((values = (String[])parameters.get(key)) == null) {
                values = new String[]{value};
            } else {
                String[] copy = new String[values.length + 1];
                System.arraycopy(values, 0, copy, 0, values.length);
                copy[copy.length - 1] = value;
                values = copy;
            }
            parameters.put(key, values);
        }
        return parameters;
    }

    public static String encodeParams(HttpServletRequest req) {
        StringBuffer result = new StringBuffer(512);
        Map params = CmsCollectionsGenericWrapper.map(req.getParameterMap());
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String param = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            for (int j = 0; j < values.length; ++j) {
                result.append(param);
                result.append(PARAMETER_ASSIGNMENT);
                result.append(CmsEncoder.encode(values[j]));
                if (j + 1 >= values.length) continue;
                result.append(PARAMETER_DELIMITER);
            }
            if (!i.hasNext()) continue;
            result.append(PARAMETER_DELIMITER);
        }
        return CmsEncoder.encode(result.toString());
    }

    public static String encodeParamsWithUri(String uri, HttpServletRequest req) {
        String params = CmsRequestUtil.encodeParams(req);
        String result = CmsStringUtil.isNotEmpty(params) ? CmsEncoder.encode(uri + URL_DELIMITER) + params : CmsEncoder.encode(uri);
        return result;
    }

    public static void forwardRequest(String target, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CmsUriSplitter uri = new CmsUriSplitter(target);
        Map<String, String[]> params = CmsRequestUtil.createParameterMap(uri.getQuery());
        CmsRequestUtil.forwardRequest(uri.getPrefix(), params, req, res);
    }

    public static void forwardRequest(String target, Map<String, String[]> params, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CmsFlexRequest f_req = (CmsFlexRequest)req;
        f_req.setParameterMap(params);
        String vfsPrefix = OpenCms.getStaticExportManager().getVfsPrefix();
        if (target.startsWith(vfsPrefix)) {
            target = target.substring(vfsPrefix.length());
            target = OpenCms.getSystemInfo().getServletPath() + target;
        }
        f_req.getRequestDispatcher(target).forward((ServletRequest)f_req, (ServletResponse)res);
    }

    public static Map<String, Object> getAtrributeMap(ServletRequest req) {
        if (req instanceof CmsFlexRequest) {
            return ((CmsFlexRequest)req).getAttributeMap();
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Enumeration atrrEnum = CmsCollectionsGenericWrapper.enumeration(req.getAttributeNames());
        while (atrrEnum.hasMoreElements()) {
            String key = (String)atrrEnum.nextElement();
            Object value = req.getAttribute(key);
            attrs.put(key, value);
        }
        return attrs;
    }

    public static String getCookieValue(CmsJspActionElement jsp, String name) {
        Cookie[] cookies = jsp.getRequest().getCookies();
        return CmsRequestUtil.getCookieValue(cookies, name);
    }

    public static String getCookieValue(Cookie[] cookies, String name) {
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    public static JSONObject getJsonParameterMap(Map<String, String[]> params) {
        JSONObject result = new JSONObject();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            String paramKey = entry.getKey();
            JSONArray paramValue = new JSONArray();
            int l = entry.getValue().length;
            for (int i = 0; i < l; ++i) {
                paramValue.put(entry.getValue()[i]);
            }
            try {
                result.putOpt(paramKey, paramValue);
            }
            catch (JSONException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static String getNotEmptyDecodedParameter(HttpServletRequest request, String paramName) {
        String result = CmsRequestUtil.getNotEmptyParameter(request, paramName);
        if (result != null) {
            result = CmsEncoder.decode(result.trim());
        }
        return result;
    }

    public static String getNotEmptyParameter(HttpServletRequest request, String paramName) {
        String result = request.getParameter(paramName);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = null;
        }
        return result;
    }

    public static Map<String, String[]> getParameterMapFromJSON(JSONObject params) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Iterator<String> itKeys = params.keys();
        while (itKeys.hasNext()) {
            String key = itKeys.next();
            JSONArray paramValue = params.optJSONArray(key);
            result.put(key, new String[paramValue.length()]);
            int l = paramValue.length();
            for (int i = 0; i < l; ++i) {
                ((String[])result.get((Object)key))[i] = paramValue.optString(i);
            }
        }
        return result;
    }

    public static Multimap<String, String> getParameters(URI uri) {
        return CmsRequestUtil.getParametersFromRawQuery(uri.getRawQuery());
    }

    public static Multimap<String, String> getParametersFromRawQuery(String rawQuery) {
        ArrayListMultimap result = ArrayListMultimap.create();
        if (rawQuery != null) {
            for (String keyValuePair : CmsStringUtil.splitAsList(rawQuery, PARAMETER_DELIMITER)) {
                try {
                    String decodedKeyValue = URLDecoder.decode(keyValuePair, "UTF-8");
                    int eqPos = decodedKeyValue.indexOf(PARAMETER_ASSIGNMENT);
                    if (eqPos < 0) {
                        decodedKeyValue = decodedKeyValue + PARAMETER_ASSIGNMENT;
                        eqPos = decodedKeyValue.indexOf(PARAMETER_ASSIGNMENT);
                    }
                    String key = decodedKeyValue.substring(0, eqPos);
                    String value = decodedKeyValue.substring(eqPos + 1);
                    result.put((Object)key, (Object)value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return result;
    }

    public static String getRequestLink(String url) {
        if (CmsStringUtil.isEmpty(url)) {
            return null;
        }
        int pos = url.indexOf(URL_DELIMITER);
        if (pos >= 0) {
            return url.substring(0, pos);
        }
        return url;
    }

    public static Object getSessionValue(HttpServletRequest request, String key) {
        HttpSession session = request.getSession(true);
        return session.getAttribute(key);
    }

    public static List<FileItem> readMultipartFileItems(HttpServletRequest request) {
        return CmsRequestUtil.readMultipartFileItems(request, OpenCms.getSystemInfo().getPackagesRfsPath());
    }

    public static List<FileItem> readMultipartFileItems(HttpServletRequest request, String tempFolderPath) {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return null;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(4096);
        factory.setRepository(new File(tempFolderPath));
        ServletFileUpload fu = new ServletFileUpload((FileItemFactory)factory);
        fu.setHeaderEncoding(request.getCharacterEncoding());
        ArrayList<FileItem> result = new ArrayList();
        try {
            List items = CmsCollectionsGenericWrapper.list(fu.parseRequest(request));
            if (items != null) {
                result = items;
            }
        }
        catch (FileUploadException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_MULIPART_REQ_FAILED_0"), (Throwable)e);
        }
        return result;
    }

    public static Map<String, String[]> readParameterMapFromMultiPart(String encoding, List<FileItem> multiPartFileItems) {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        for (FileItem item : multiPartFileItems) {
            String name = item.getFieldName();
            String value = null;
            if (name == null || item.getName() != null) continue;
            try {
                value = item.getString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ENC_MULTIPART_REQ_ERROR_0"), (Throwable)e);
                value = item.getString();
            }
            if (parameterMap.containsKey(name)) {
                String[] oldValues = (String[])parameterMap.get(name);
                String[] newValues = new String[oldValues.length + 1];
                System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                newValues[oldValues.length] = value;
                parameterMap.put(name, newValues);
                continue;
            }
            parameterMap.put(name, new String[]{value});
        }
        return parameterMap;
    }

    public static void redirectPermanently(CmsJspActionElement jsp, String target) {
        target = OpenCms.getLinkManager().substituteLink(jsp.getCmsObject(), target);
        jsp.getResponse().setHeader(HEADER_CONNECTION, "close");
        try {
            HttpServletResponse response = jsp.getResponse();
            if (response instanceof CmsFlexResponse) {
                ((CmsFlexResponse)jsp.getResponse()).sendRedirect(target, true);
            } else {
                response.setHeader(HEADER_LOCATION, target);
                response.setStatus(301);
            }
        }
        catch (IOException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_IOERROR_0"), (Throwable)e);
        }
    }

    public static void redirectRequestSecure(CmsJspActionElement jsp, String target) throws IOException {
        jsp.getResponse().sendRedirect(OpenCms.getLinkManager().substituteLink(jsp.getCmsObject(), target, null, true));
    }

    public static void removeSessionValue(HttpServletRequest request, String key) {
        HttpSession session = request.getSession(true);
        session.removeAttribute(key);
    }

    public static void setCookieValue(CmsJspActionElement jsp, String name, String value) {
        Cookie[] cookies = jsp.getRequest().getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
            cookies[i].setValue(value);
            return;
        }
        Cookie cookie = new Cookie(name, value);
        jsp.getResponse().addCookie(cookie);
    }

    public static void setNoCacheHeaders(HttpServletResponse res) {
        res.setHeader(HEADER_CACHE_CONTROL, "max-age=0");
        res.addHeader(HEADER_CACHE_CONTROL, HEADER_VALUE_MUST_REVALIDATE);
        res.addHeader(HEADER_CACHE_CONTROL, HEADER_VALUE_NO_CACHE);
        res.addHeader(HEADER_CACHE_CONTROL, HEADER_VALUE_NO_STORE);
        res.setHeader(HEADER_PRAGMA, HEADER_VALUE_NO_CACHE);
    }

    public static void setSessionValue(HttpServletRequest request, String key, Object value) {
        HttpSession session = request.getSession(true);
        session.setAttribute(key, value);
    }
}

