/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.net.URI;
import java.net.URISyntaxException;

public class CmsUriSplitter {
    private static final StringBuffer EMPTY_BUFFER = new StringBuffer(0);
    private String m_anchor;
    private boolean m_errorFree;
    private boolean m_isStrict;
    private String m_protocol;
    private String m_prefix;
    private String m_query;
    private String m_suffix;
    private String m_uri;

    public CmsUriSplitter(String uri) {
        this(uri, false);
    }

    public CmsUriSplitter(String uri, boolean strict) {
        this.m_uri = uri;
        this.m_errorFree = true;
        this.m_isStrict = strict;
        if (strict) {
            try {
                int i;
                URI u = new URI(uri);
                this.m_protocol = u.getScheme();
                this.m_prefix = (this.m_protocol != null ? this.m_protocol + ":" : "") + u.getRawSchemeSpecificPart();
                this.m_anchor = u.getRawFragment();
                this.m_query = u.getRawQuery();
                if (this.m_prefix != null && (i = this.m_prefix.indexOf(63)) != -1) {
                    this.m_query = this.m_prefix.substring(i + 1);
                    this.m_prefix = this.m_prefix.substring(0, i);
                }
                if (this.m_anchor != null && (i = this.m_anchor.indexOf(63)) != -1) {
                    this.m_query = this.m_anchor.substring(i + 1);
                    this.m_anchor = this.m_anchor.substring(0, i);
                }
            }
            catch (Exception exc) {
                strict = false;
                this.m_errorFree = false;
            }
        }
        if (!strict && uri != null) {
            StringBuffer prefix = new StringBuffer(uri.length());
            StringBuffer anchor = EMPTY_BUFFER;
            StringBuffer query = EMPTY_BUFFER;
            int len = uri.length();
            int cur = 0;
            block6: for (int i = 0; i < len; ++i) {
                char c = uri.charAt(i);
                if (cur == 0 && c == ':') {
                    this.m_protocol = prefix.toString();
                }
                if (c == '#') {
                    cur = 1;
                    anchor = new StringBuffer(uri.length());
                    continue;
                }
                if (c == '?') {
                    cur = 2;
                    query = new StringBuffer(uri.length());
                    continue;
                }
                switch (cur) {
                    case 1: {
                        anchor.append(c);
                        continue block6;
                    }
                    case 2: {
                        query.append(c);
                        continue block6;
                    }
                    default: {
                        prefix.append(c);
                    }
                }
            }
            if (prefix.length() > 0) {
                this.m_prefix = prefix.toString();
            }
            if (anchor.length() > 0) {
                this.m_anchor = anchor.toString();
            }
            if (query.length() > 0) {
                this.m_query = query.toString();
            }
        }
    }

    public static boolean isValidUri(String uri) {
        boolean result = false;
        try {
            new URI(uri);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsUriSplitter) {
            CmsUriSplitter other = (CmsUriSplitter)obj;
            if (!(this.m_protocol == other.m_protocol || this.m_protocol != null && this.m_protocol.equals(other.m_protocol))) {
                return false;
            }
            if (!(this.m_prefix == other.m_prefix || this.m_prefix != null && this.m_prefix.equals(other.m_prefix))) {
                return false;
            }
            if (!(this.m_anchor == other.m_anchor || this.m_anchor != null && this.m_anchor.equals(other.m_anchor))) {
                return false;
            }
            return this.m_query == other.m_query || this.m_query != null && this.m_query.equals(other.m_query);
        }
        return false;
    }

    public String getAnchor() {
        return this.m_anchor;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String getQuery() {
        return this.m_query;
    }

    public String getSuffix() {
        if (this.m_suffix == null) {
            StringBuffer result = new StringBuffer();
            if (this.m_query != null) {
                result.append('?');
                result.append(this.m_query);
            }
            if (this.m_anchor != null) {
                result.append('#');
                result.append(this.m_anchor);
            }
            this.m_suffix = result.toString();
        }
        return this.m_suffix;
    }

    public String getUri() {
        return this.m_uri;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.m_prefix != null) {
            hashCode += this.m_prefix.hashCode();
        }
        if (this.m_anchor != null) {
            hashCode += this.m_anchor.hashCode();
        }
        if (this.m_query != null) {
            hashCode += this.m_query.hashCode();
        }
        return hashCode;
    }

    public boolean isErrorFree() {
        return this.m_errorFree;
    }

    public URI toURI() throws URISyntaxException {
        if (this.m_isStrict && this.m_errorFree) {
            return new URI(this.m_uri);
        }
        return new URI(null, this.m_prefix + (this.m_query != null ? "?" + this.m_query : ""), this.m_anchor);
    }
}

