/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.formatters.CmsFormatterChangeSet;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.A_CmsXmlContentValue;

public abstract class A_CmsFormatterWidget
extends CmsSelectWidget {
    private static final Log LOG = CmsLog.getLog(A_CmsFormatterWidget.class);

    public static CmsSelectWidgetOption getWidgetOptionForFormatter(CmsObject cms, I_CmsFormatterBean formatter) {
        String name = formatter.getNiceName(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)) + " " + formatter.getResourceTypeNames().toString() + "   (" + formatter.getJspRootPath() + ")";
        CmsSelectWidgetOption option = new CmsSelectWidgetOption(formatter.getId(), false, name);
        return option;
    }

    public static CmsSelectWidgetOption getWidgetOptionForType(CmsObject cms, String typeName) {
        String niceTypeName = typeName;
        try {
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            niceTypeName = CmsWorkplaceMessages.getResourceTypeName(locale, typeName);
        }
        catch (Exception locale) {
            // empty catch block
        }
        CmsSelectWidgetOption option = new CmsSelectWidgetOption(CmsFormatterChangeSet.keyForType(typeName), false, A_CmsFormatterWidget.getMessage(cms, "GUI_SCHEMA_FORMATTER_OPTION_1", niceTypeName));
        return option;
    }

    static String getMessage(CmsObject cms, String message, Object ... args) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        return Messages.get().getBundle(locale).key(message, args);
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        A_CmsWidget.CmsDummyWidgetDialog widgetDialog = new A_CmsWidget.CmsDummyWidgetDialog(this, messages.getLocale(), messages);
        widgetDialog.setResource(resource);
        String result = this.getConfiguration();
        result = result + "||";
        result = result + this.optionsToConfigurationString(this.parseSelectOptions(cms, widgetDialog, schemaType, false));
        result = result + "||";
        result = result + this.optionsToConfigurationString(this.parseSelectOptions(cms, widgetDialog, schemaType, true));
        return result;
    }

    @Override
    public String getWidgetName() {
        return A_CmsFormatterWidget.class.getName();
    }

    protected abstract List<CmsSelectWidgetOption> getFormatterOptions(CmsObject var1, CmsADEConfigData var2, String var3, boolean var4);

    protected abstract Set<String> getSelectedInFile(CmsConfigurationReader var1, CmsXmlContent var2);

    protected abstract List<CmsSelectWidgetOption> getTypeOptions(CmsObject var1, CmsADEConfigData var2, boolean var3);

    @Override
    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        ArrayList options = Lists.newArrayList();
        options.add(new CmsSelectWidgetOption("", true, A_CmsFormatterWidget.getMessage(cms, "GUI_FORMATTER_EMPTY_SELECTION_0", new Object[0])));
        return options;
    }

    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param, boolean allRemoved) {
        String path = this.getResourcePath(cms, widgetDialog);
        try {
            cms = OpenCms.initCmsObject(cms);
            cms.getRequestContext().setSiteRoot("");
            CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, path);
            if (adeConfig.parent() != null) {
                adeConfig = adeConfig.parent();
            }
            HashSet<String> added = new HashSet<String>();
            ArrayList options = Lists.newArrayList();
            options.add(new CmsSelectWidgetOption("", true, A_CmsFormatterWidget.getMessage(cms, "GUI_FORMATTER_EMPTY_SELECTION_0", new Object[0])));
            List<CmsSelectWidgetOption> formatterOptions = this.getFormatterOptions(cms, adeConfig, path, allRemoved);
            options.addAll(formatterOptions);
            List<CmsSelectWidgetOption> typeOptions = this.getTypeOptions(cms, adeConfig, allRemoved);
            options.addAll(typeOptions);
            for (CmsSelectWidgetOption option : options) {
                added.add(option.getValue());
            }
            try {
                CmsResource content = cms.readResource(path);
                CmsFile contentFile = cms.readFile(content);
                CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, contentFile);
                CmsConfigurationReader reader = new CmsConfigurationReader(cms);
                Set<String> selected = this.getSelectedInFile(reader, xmlContent);
                Iterator<String> iterator = selected.iterator();
                while (iterator.hasNext()) {
                    CmsSelectWidgetOption option;
                    String formatterKey;
                    String title = formatterKey = iterator.next();
                    if (CmsUUID.isValidUUID(formatterKey)) {
                        CmsFormatterConfigurationCacheState cacheState = OpenCms.getADEManager().getCachedFormatters(cms.getRequestContext().getCurrentProject().isOnlineProject());
                        CmsUUID mapKey = new CmsUUID(formatterKey);
                        I_CmsFormatterBean formatter = cacheState.getFormatters().get(mapKey);
                        if (formatter != null) {
                            title = A_CmsFormatterWidget.getWidgetOptionForFormatter(cms, formatter).getOption();
                        }
                    }
                    if (added.contains((option = new CmsSelectWidgetOption(formatterKey, false, title)).getValue())) continue;
                    options.add(option);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return options;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static class FormatterSelectComparator
    implements Comparator<I_CmsFormatterBean> {
        @Override
        public int compare(I_CmsFormatterBean first, I_CmsFormatterBean second) {
            TreeSet<String> firstSet = new TreeSet<String>(first.getResourceTypeNames());
            TreeSet<String> secondSet = new TreeSet<String>(second.getResourceTypeNames());
            return ComparisonChain.start().compare((Comparable)((Object)((Object)firstSet).toString()), (Comparable)((Object)((Object)secondSet).toString())).compare(first.getRank(), second.getRank()).result();
        }
    }
}

