/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.A_CmsFormatterWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.containerpage.CmsMacroFormatterBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentRootLocation;

public class CmsAddFormatterWidget
extends A_CmsFormatterWidget {
    private static final Log LOG = CmsLog.getLog(CmsAddFormatterWidget.class);

    public CmsAddFormatterWidget() {
    }

    public CmsAddFormatterWidget(String config) {
    }

    public static List<String> getSelectOptionValues(CmsObject cms, String rootPath, boolean allRemoved) {
        try {
            cms = OpenCms.initCmsObject(cms);
            cms.getRequestContext().setSiteRoot("");
            CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, rootPath);
            if (adeConfig.parent() != null) {
                adeConfig = adeConfig.parent();
            }
            List<CmsSelectWidgetOption> options = CmsAddFormatterWidget.getFormatterOptionsStatic(cms, adeConfig, rootPath, allRemoved);
            List<CmsSelectWidgetOption> typeOptions = CmsAddFormatterWidget.getTypeOptionsStatic(cms, adeConfig, allRemoved);
            options.addAll(typeOptions);
            ArrayList<String> result = new ArrayList<String>(options.size());
            for (CmsSelectWidgetOption o : options) {
                result.add(o.getValue());
            }
            return result;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    protected static List<CmsSelectWidgetOption> getFormatterOptionsStatic(CmsObject cms, CmsADEConfigData config, String rootPath, boolean allRemoved) {
        Map<CmsUUID, I_CmsFormatterBean> inactiveFormatters = config.getInactiveFormatters();
        ArrayList result = Lists.newArrayList();
        ArrayList formatters = Lists.newArrayList(inactiveFormatters.values());
        if (allRemoved) {
            Map<CmsUUID, I_CmsFormatterBean> activeFormatters = config.getActiveFormatters();
            formatters.addAll(Lists.newArrayList(activeFormatters.values()));
        }
        Collections.sort(formatters, new A_CmsFormatterWidget.FormatterSelectComparator());
        for (I_CmsFormatterBean formatterBean : formatters) {
            if (formatterBean instanceof CmsMacroFormatterBean) {
                boolean systemOrShared;
                boolean bl = systemOrShared = formatterBean.getLocation().startsWith("/system/") || formatterBean.getLocation().startsWith(OpenCms.getSiteManager().getSharedFolder());
                if (!systemOrShared) {
                    String formatterSubSite = CmsResource.getParentFolder(CmsResource.getParentFolder(CmsResource.getParentFolder(formatterBean.getLocation())));
                    String subSite = CmsResource.getParentFolder(CmsResource.getParentFolder(rootPath));
                    if (subSite.equals(formatterSubSite) || !subSite.startsWith(formatterSubSite)) continue;
                }
            }
            CmsSelectWidgetOption option = CmsAddFormatterWidget.getWidgetOptionForFormatter(cms, formatterBean);
            result.add(option);
        }
        return result;
    }

    protected static List<CmsSelectWidgetOption> getTypeOptionsStatic(CmsObject cms, CmsADEConfigData adeConfig, boolean allRemoved) {
        ArrayList result = Lists.newArrayList();
        Set<String> types = adeConfig.getTypesWithModifiableFormatters();
        HashSet<String> inactiveTypes = new HashSet<String>(types);
        if (!allRemoved) {
            Set<String> activeTypes = adeConfig.getTypesWithActiveSchemaFormatters();
            inactiveTypes.removeAll(activeTypes);
        }
        for (String inactiveType : inactiveTypes) {
            CmsSelectWidgetOption option = CmsAddFormatterWidget.getWidgetOptionForType(cms, inactiveType);
            result.add(option);
        }
        return result;
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsAddFormatterWidget();
    }

    @Override
    protected List<CmsSelectWidgetOption> getFormatterOptions(CmsObject cms, CmsADEConfigData config, String rootPath, boolean allRemoved) {
        return CmsAddFormatterWidget.getFormatterOptionsStatic(cms, config, rootPath, allRemoved);
    }

    @Override
    protected Set<String> getSelectedInFile(CmsConfigurationReader reader, CmsXmlContent content) {
        CmsXmlContentRootLocation root = new CmsXmlContentRootLocation(content, Locale.ENGLISH);
        Set<String> addFormatters = reader.parseAddFormatters(root);
        return addFormatters;
    }

    @Override
    protected List<CmsSelectWidgetOption> getTypeOptions(CmsObject cms, CmsADEConfigData adeConfig, boolean allRemoved) {
        return CmsAddFormatterWidget.getTypeOptionsStatic(cms, adeConfig, allRemoved);
    }
}

