/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import org.apache.commons.logging.Log;
import org.opencms.ade.contenteditor.shared.CmsComplexWidgetData;
import org.opencms.file.CmsObject;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.widgets.CmsWidgetConfigurationException;
import org.opencms.widgets.I_CmsComplexWidget;
import org.opencms.widgets.dataview.I_CmsDataView;

public class CmsDataViewWidget
implements I_CmsComplexWidget {
    private static final Log LOG = CmsLog.getLog(CmsDataViewWidget.class);
    private String m_config;

    public CmsDataViewWidget() {
        this("");
    }

    public CmsDataViewWidget(String config) {
        this.m_config = config;
    }

    @Override
    public I_CmsComplexWidget configure(String configuration) {
        this.validateConfiguration(configuration);
        return new CmsDataViewWidget(configuration);
    }

    @Override
    public String getName() {
        return "dataview";
    }

    @Override
    public CmsComplexWidgetData getWidgetData(CmsObject cms) {
        String configToUse = this.m_config;
        try {
            JSONObject json = new JSONObject(this.m_config);
            String icon = json.optString("icon");
            if (icon != null) {
                String iconLink = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, icon);
                json.put("icon", iconLink);
                configToUse = json.toString();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return new CmsComplexWidgetData("dataview", configToUse, null);
    }

    public void validateConfiguration(String configuration) {
        try {
            JSONObject json = new JSONObject(configuration);
            String className = json.optString("class");
            Class<?> cls = Class.forName(className, false, this.getClass().getClassLoader());
            if (!I_CmsDataView.class.isAssignableFrom(cls)) {
                throw new IllegalArgumentException("Class " + cls.getName() + " does not implement " + I_CmsDataView.class.getName());
            }
        }
        catch (Exception e) {
            throw new CmsWidgetConfigurationException(e);
        }
    }
}

